<?php

class Waindigo_PhpFile_Variable
{
    protected $_variableName;
    protected $_phpDoc = array();
    protected $_public = false;
    protected $_protected = false;
    protected $_static = false;
    protected $_value = array();

    public function __construct($variableName)
    {
        $this->_variableName = $variableName;
    } /* END __construct */

    public function getVariableName()
    {
        return $this->_variableName;
    } /* END getVariableName */

    public function getFullSignatureAsString()
    {
        $contents = '';
        if ($this->_public || substr($this->_variableName, 0, 1) != '_')
        {
            $contents.= "public ";
        }
        else if ($this->_protected || substr($this->_variableName, 0, 2) != '__')
        {
            $contents.= "protected ";
        }
        else
        {
            $contents.= "private ";
        }
        if ($this->_static)
        {
            $contents.= "static ";
        }
        $contents.= '$'.$this->_variableName;
        return $contents;
    } /* END getFullSignatureAsString */

    public function getValue()
    {
        return $this->_value;
    } /* END getValue */

    public function hasValue()
    {
        return !empty($this->_value);
    } /* END hasValue */

    public function setValue($value)
    {
        $this->_value = $value;
    } /* END setValue */

    public function getPhpDoc()
    {
        return $this->_phpDoc;
    } /* END getPhpDoc */

    public function getPhpDocAsString()
    {
        $contents = '';
        if (!empty($this->_phpDoc))
        {
            $contents.= "\n    /**";
            foreach ($this->_phpDoc as $phpDoc)
            {
                $contents.= rtrim("\n     * $phpDoc");
            }
            $contents.= "\n     */";
        }
        return $contents;
    } /* END getPhpDocAsString */

    public function hasPhpDoc()
    {
        return !empty($this->_phpDoc);
    } /* END hasPhpDoc */

    public function setPhpDoc($phpDoc)
    {
        if (is_array($phpDoc))
        {
            $this->_phpDoc = $phpDoc;
        }
        else
        {
            $this->_phpDoc = array($phpDoc);
        }
    } /* END setPhpDoc */

    public function isPublic()
    {
        return $this->_public;
    } /* END isPublic */

    public function isProtected()
    {
        return $this->_protected;
    } /* END isProtected */

    public function isStatic()
    {
        return $this->_static;
    } /* END isStatic */

    public function setPublic($public = true)
    {
        $this->_public = $public;
    } /* END setPublic */

    public function setProtected($protected = true)
    {
        $this->_protected = $protected;
    } /* END setProtected */

    public function setStatic($static = true)
    {
        $this->_static = $static;
    } /* END setStatic */
}