<?php

/**
 *
 * @see Waindigo_SocialGroups_ControllerAdmin_SocialCategory
 */
class Waindigo_SocialFeeds_Extend_Waindigo_SocialGroups_ControllerAdmin_SocialCategory extends XFCP_Waindigo_SocialFeeds_Extend_Waindigo_SocialGroups_ControllerAdmin_SocialCategory
{

    /**
     * Fetches a list of all social forums in the specified social category
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionSocialForums()
    {
        $this->_assertPostOnly();

        $socialCategoryId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);

        /* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
        $socialForumModel = Waindigo_SocialGroups_SocialForum::getSocialForumModel();

        $socialForums = $socialForumModel->getSocialForums(array(
        	'node_id' => $socialCategoryId
        ));
        $viewParams = array(
            'socialForums' => $socialForums
        );

        return $this->responseView('Waindigo_SocialFeeds_ViewAdmin_SocialCategory_SocialForums', '', $viewParams);
    } /* END actionSocialForums */
}