<?php

/**
 *
 * @see XenForo_DataWriter_Feed
 */
class Waindigo_SocialFeeds_Extend_XenForo_DataWriter_Feed extends XFCP_Waindigo_SocialFeeds_Extend_XenForo_DataWriter_Feed
{

    /**
     *
     * @see XenForo_DataWriter_Feed::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_feed']['social_forum_id_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'required' => true,
            'verification' => array(
                '$this',
                '_verifySocialForumId'
            )
        );

        return $fields;
    } /* END _getFields */

    protected function _verifySocialForumId(&$socialForumId)
    {
        if (!$socialForumId) {
            $forum = $this->getModelFromCache('XenForo_Model_Forum')->getForumById($this->get('node_id'));

            if (!$forum) {
                $this->error(new XenForo_Phrase('please_select_valid_forum'), 'node_id');
                return false;
            } elseif ($forum['node_type_id'] == 'SocialCategory') {
                $this->error(new XenForo_Phrase('waindigo_please_select_valid_social_forum_socialfeeds'),
                    'social_forum_id');
                return false;
            }

            return true;
        }

        /* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
        $socialForumModel = Waindigo_SocialGroups_SocialForum::getSocialForumModel();

        $socialForum = $socialForumModel->getSocialForumById($socialForumId);
        if (!$socialForum || $socialForum['node_id'] != $this->get('node_id')) {
            $this->error(new XenForo_Phrase('waindigo_please_select_valid_social_forum_socialfeeds'), 'social_forum_id');
            return false;
        }

        return true;
    } /* END _verifySocialForumId */

    protected function _preSave()
    {
        if (!empty($GLOBALS['XenForo_ControllerAdmin_Feed'])) {
            /* @var $controller XenForo_ControllerAdmin_Feed */
            $controller = $GLOBALS['XenForo_ControllerAdmin_Feed'];

            $socialForumId = $controller->getInput()->filterSingle('social_forum_id_waindigo', XenForo_Input::UINT);

            if ($socialForumId) {
                $this->set('social_forum_id_waindigo', $socialForumId);
            } elseif ($this->isChanged('node_id')) {
                $this->set('social_forum_id_waindigo', 0);
            }
        }

        parent::_preSave();
    } /* END _preSave */
}