<?php

/**
 *
 * @see XenForo_Model_Feed
 */
class Waindigo_SocialFeeds_Extend_XenForo_Model_Feed extends XFCP_Waindigo_SocialFeeds_Extend_XenForo_Model_Feed
{

    /**
     *
     * @see XenForo_Model_Feed::_insertFeedEntry()
     */
    protected function _insertFeedEntry(array $entryData, array $feedData, array $feed)
    {
        if ($feed['social_forum_id_waindigo']) {
            $socialForum = null;
            if (!Waindigo_SocialGroups_SocialForum::hasInstance()) {
                $socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
            }
            if (!$socialForum || $socialForum['social_forum_id'] != $feed['social_forum_id_waindigo']) {
                $socialForum = Waindigo_SocialGroups_SocialForum::setup($feed['social_forum_id_waindigo']);
            }
        } elseif (Waindigo_SocialGroups_SocialForum::hasInstance()) {
            $socialForum = Waindigo_SocialGroups_SocialForum::setup(0);
        }

        return parent::_insertFeedEntry($entryData, $feedData, $feed);
    } /* END _insertFeedEntry */
}