<?php

class Waindigo_SocialFeeds_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_SocialFeeds' => array(
                'controller' => array(
                    'XenForo_ControllerAdmin_Feed',
                    'Waindigo_SocialGroups_ControllerAdmin_SocialCategory'
                ), /* END 'controller' */
                'datawriter' => array(
                    'XenForo_DataWriter_Feed'
                ), /* END 'datawriter' */
                'model' => array(
                    'XenForo_Model_Feed'
                ), /* END 'model' */
            ), /* END 'Waindigo_SocialFeeds' */
        );
    } /* END _getExtendedClasses */

    public static function loadClassController($class, array &$extend)
    {
        $loadClassController = new Waindigo_SocialFeeds_Listener_LoadClass($class, $extend, 'controller');
        $extend = $loadClassController->run();
    } /* END loadClassController */

    public static function loadClassDataWriter($class, array &$extend)
    {
        $loadClassDataWriter = new Waindigo_SocialFeeds_Listener_LoadClass($class, $extend, 'datawriter');
        $extend = $loadClassDataWriter->run();
    } /* END loadClassDataWriter */

    public static function loadClassModel($class, array &$extend)
    {
        $loadClassModel = new Waindigo_SocialFeeds_Listener_LoadClass($class, $extend, 'model');
        $extend = $loadClassModel->run();
    } /* END loadClassModel */
}