<?php

/**
 * Alert handler for users.
 *
 * @package XenForo_Alert
 */
class Waindigo_SocialGroups_AlertHandler_SocialForum extends XenForo_AlertHandler_Abstract
{
	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		/* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
		$socialForumModel = $model->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');

		return $socialForumModel->getSocialForums(array('social_forum_ids' => $contentIds));
	}
}