<?php

/**
 * Cache rebuilder for social forums.
 */
class Waindigo_SocialGroups_CacheRebuilder_SocialForum extends XenForo_CacheRebuilder_Abstract
{
	/**
	 * Gets rebuild message.
	 */
	public function getRebuildMessage()
	{
		return new XenForo_Phrase('waindigo_social_forums_social_groups');
	}

	/**
	 * Shows the exit link.
	 */
	public function showExitLink()
	{
		return true;
	}

	/**
	 * Rebuilds the data.
	 *
	 * @see XenForo_CacheRebuilder_Abstract::rebuild()
	 */
	public function rebuild($position = 0, array &$options = array(), &$detailedMessage = '')
	{
		$options['batch'] = max(1, isset($options['batch']) ? $options['batch'] : 10);

		/* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
		$socialForumModel = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForum');

		$socialForums = $socialForumModel->getSocialForums(array(), array('limit' => $options['batch'], 'offset' => $position));

		XenForo_Db::beginTransaction();

		foreach ($socialForums AS $socialForum)
		{
			$position++;

			/* @var $socialForumDw Waindigo_SocialGroups_DataWriter_SocialForum */
			$socialForumDw = XenForo_DataWriter::create('Waindigo_SocialGroups_DataWriter_SocialForum', XenForo_DataWriter::ERROR_SILENT);
			if ($socialForumDw->setExistingData($socialForum, true))
			{
				$socialForumDw->rebuildCounters();
				$socialForumDw->save();
			}
		}

		XenForo_Db::commit();

		$detailedMessage = XenForo_Locale::numberFormat($position);

		if (!$socialForums)
		{
			return true;
		}
		else
		{
			return $position;
		}
	}
}