<?php

class Waindigo_SocialGroups_ControllerPublic_Account extends XFCP_Waindigo_SocialGroups_ControllerPublic_Account
{
	/**
	 * Save profile data
	 *
	 * @return XenForo_ControllerResponse_Redirect
	 */
	public function actionPersonalDetailsSave()
	{
		$GLOBALS['Waindigo_SocialGroups_ControllerPublic_Account'] = $this;
		
		return parent::actionPersonalDetailsSave();
	}
	
	public function processSocialForums(XenForo_DataWriter_User $dw)
	{
		$primarySocialForumId = $this->_input->filterSingle('primary_social_forum_id', XenForo_Input::UINT);
		$secondarySocialForumIds = $this->_input->filterSingle('secondary_social_forum_ids', XenForo_Input::ARRAY_SIMPLE);
		
		if ($primarySocialForumId && in_array($primarySocialForumId, $secondarySocialForumIds))
		{
			unset($secondarySocialForumIds[array_search($primarySocialForumId, $secondarySocialForumIds)]);
		}
		
		$secondarySocialForumIds = implode(",", $secondarySocialForumIds);
		
		$dw->set('primary_social_forum_id', $primarySocialForumId);
		$dw->set('secondary_social_forum_ids', $secondarySocialForumIds);
	}
	
	/**
	 * @return Waindigo_SocialGroups_Model_SocialForum
	 */
	protected function _getSocialForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');
	}
	
}