<?php

class Waindigo_SocialGroups_ControllerPublic_Events extends XFCP_Waindigo_SocialGroups_ControllerPublic_Events
{

	public function actionCreate()
	{
		if (!$this->perms['post']) { return $this->responseNoPermission(); }

		if ($this->_request->isPost())
		{
			$input = $this->_input->filter(array(
				'event_title' => XenForo_Input::STRING,
				'event_venue' => XenForo_Input::STRING,
				'event_address' => XenForo_Input::STRING,
				'event_citystate' => XenForo_Input::STRING,
				'event_zipcode' => XenForo_Input::STRING,
				'event_date' => XenForo_Input::STRING,
				'event_time' => XenForo_Input::STRING,
				'event_ampm' => XenForo_Input::STRING,
				'event_length' => XenForo_Input::STRING,
				'event_timezone' => XenForo_Input::STRING,
				'event_stream' => XenForo_Input::STRING,
				'event_rsvp' => XenForo_Input::UINT,
				'event_recur' => XenForo_Input::UINT,
				'event_recur_count' => XenForo_Input::UINT,
				'event_recur_units' => XenForo_Input::STRING,
				'event_expire' => XenForo_Input::UINT,
				'event_recur_expire' => XenForo_Input::STRING,
				'event_node' => XenForo_Input::STRING,
				'event_247' => XenForo_Input::UINT,
				'create_thread' => XenForo_Input::UINT,
				'submit' => XenForo_Input::STRING,
			));
			
			$eventNode = explode("-", $input['event_node']);
			if (isset($eventNode[1]))
			{
				$socialForum = Waindigo_SocialGroups_SocialForum::setup($eventNode[1]);
			}
			
			if ($input['event_description'] = $this->getHelper('Editor')->getMessageText('event_description', $this->_input))
			{
				$input['bypass'] = $this->perms['bypass'];
				$event = $this->getModelFromCache('EWRatendo_Model_Events')->updateEvent($input);
				return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, XenForo_Link::buildPublicLink('events', $event));
			}
		}
		/* @var $response XenForo_ControllerResponse_View */
		$response = parent::actionCreate();
		
		if (get_class($response) == 'XenForo_ControllerResponse_View')
		{
			$forums = array();
			foreach (XenForo_Application::get('options')->EWRatendo_eventforums AS $forum)
			{
				$oldForums = array();
				foreach ($response->params['forums'] as $oldForumId => $oldForum)
				{
					$oldForums[$oldForum['node_id']] = $oldForumId;
				}
				if (array_key_exists($forum, $oldForums) && $response->params['forums'][$oldForums[$forum]]['node_type_id'] != 'SocialCategory')
				{
					$forums[] = $response->params['forums'][$oldForums[$forum]];
				}
				else
				{
					if (!array_key_exists($forum, $oldForums))
					{
						$newForum = $this->getModelFromCache('XenForo_Model_Forum')->getForumById($forum);
					}
					else
					{
						$newForum = $response->params['forums'][$oldForums[$forum]];
					}

					if ($newForum && $newForum['node_type_id'] == 'SocialCategory')
					{
						/* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
						$socialForumModel = $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');

						$socialForums = $socialForumModel->getSocialForumsInForum($forum);

						/* @var $socialForumMemberModel Waindigo_SocialGroups_Model_SocialForumMember */
						$socialForumMemberModel = $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForumMember');
						
						foreach ($socialForums as $socialForum)
						{
							$members = $socialForumMemberModel->getSocialForumMembers(array('social_forum_id' => $socialForum['social_forum_id']));
							$nodePermissions = $socialForumModel->getNodePermissions($socialForum, $members);
							if (isset($nodePermissions['postThread']) && $nodePermissions['postThread'])
							{
								$forums[] = array(
									'node_id' => $socialForum['node_id']."-".$socialForum['social_forum_id'],
									'title' => $socialForum['title'],
								);
							}
						}
					}
						
				}
			}
			$response->params['forums'] = $forums;
		}
		
		return $response;
	}
	
}