<?php

/**
 * Controller for handling actions on forums.
 */
class Waindigo_SocialGroups_ControllerPublic_Forum extends XFCP_Waindigo_SocialGroups_ControllerPublic_Forum
{
	/**
	 * Displays the contents of a forum.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionIndex()
	{
		$response = parent::actionIndex();

		if (get_class($response) == "XenForo_ControllerResponse_View")
		{
			if (isset($response->params['forum']))
			{
				$forum = $response->params['forum'];
				
				if ($forum['node_type_id'] == "SocialCategory")
				{
					return $this->responseRedirect(
						XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL_PERMANENT,
						XenForo_Link::buildPublicLink('index')
					);
				}
			}
		}
		
		return $response;
	}
}