<?php

class Waindigo_SocialGroups_ControllerPublic_Member extends XFCP_Waindigo_SocialGroups_ControllerPublic_Member
{
	/**
	 * Gets social forums for the specified member
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionSocialForums()
	{
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);

		$socialForumModel = $this->_getSocialForumModel();

		$socialForums = $socialForumModel->getSocialForums(array(
			'user_id' => $userId,		
		));

		foreach ($socialForums AS &$socialForum)
		{
			$socialForum = $socialForumModel->prepareSocialForum($socialForum);
		}
		
		$viewParams = array(
			'socialForums' => $socialForums,
		);
		
		return $this->responseView('Waindigo_SocialGroups_ViewPublic_Member_SocialForums', 'waindigo_member_social_forums_social_groups', $viewParams);
	}
	
	/**
	 * @return Waindigo_SocialGroups_Model_SocialForum
	 */
	protected function _getSocialForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');
	}
	
}