<?php

/**
 * Controller for handling actions on social categories.
 */
class Waindigo_SocialGroups_ControllerPublic_SocialCategory extends XenForo_ControllerPublic_Forum
{
	protected function _postDispatch($controllerResponse, $controllerName, $action)
	{
		parent::_postDispatch($controllerResponse, $controllerName, $action);
	
		if (class_exists('NodesAsTabs_Listen') && method_exists('NodesAsTabs_Listen', 'breadCrumbs'))
		{
			try {
				$optionsModel = XenForo_Model::create('NodesAsTabs_Model_Options');
				$routeMatch = $this->getRouteMatch();
				$request = $this->getRequest();
				$viewParams = (isset($controllerResponse->params) ? $controllerResponse->params : array());
	
				// DO ROUTE STUFF
				// THIS IS DONE IN CONTROLLER INSTEAD OF ROUTER
				// SO WE CAN ACCESS NODE RECORD TO SAVE A QUERY
	
				$nodeId = 0;
				if (!empty($viewParams['forum']['node_id']))
				$nodeId = $viewParams['forum']['node_id'];
				$nodeId = ($nodeId ? $nodeId : $optionsModel->getNodeIdFromRequest($request));
	
				$nodeTabId = $optionsModel->handleRoute($nodeId, $routeMatch);
	
				// USED LATER FOR BREADCRUMBS
				$controllerResponse->containerParams['nodeTabId'] = $nodeTabId;
			} catch (Exception $e) {
				// do nothing
			}
		}
	}
	
	/**
	* Displays the contents of a forum.
	*
	* @return XenForo_ControllerResponse_Abstract
	*/
	public function actionIndex()
	{
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
		if (!$forumId && !$forumName)
		{
			if ($this->_routeMatch->getResponseType() == 'rss')
			{
				return $this->getGlobalForumRss();
			}
			else
			{
				return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL_PERMANENT,
				XenForo_Link::buildPublicLink('index')
				);
			}
		}
	
		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $this->getHelper('ForumThreadPost')->assertForumValidAndViewable(
		$forumId ? $forumId : $forumName,
		$this->_getForumFetchOptions()
		);
		$forumId = $forum['node_id'];
	
		$visitor = XenForo_Visitor::getInstance();
		$socialForumModel = $this->_getSocialForumModel();
		$forumModel = $this->_getForumModel();
	
		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		$socialForumsPerPage = XenForo_Application::get('options')->socialForumsPerPage;
	
		$this->canonicalizeRequestUrl(
			XenForo_Link::buildPublicLink('social-categories', $forum, array('page' => $page))
		);
	
		list($defaultOrder, $defaultOrderDirection) = $this->_getDefaultSocialForumSort($forum);
	
		$order = $this->_input->filterSingle('order', XenForo_Input::STRING, array('default' => $defaultOrder));
		$orderDirection = $this->_input->filterSingle('direction', XenForo_Input::STRING, array('default' => $defaultOrderDirection));
	
		$displayConditions = $this->_getDisplayConditions($forum);
	
		$fetchElements = $this->_getSocialForumFetchElements(
			$forum, $displayConditions,
			$socialForumsPerPage, $page, $order, $orderDirection
		);
		$socialForumFetchConditions = $fetchElements['conditions'];
		$socialForumFetchOptions = $fetchElements['options'] + array(
			'perPage' => $socialForumsPerPage,
			'page' => $page,
			'order' => $order,
			'orderDirection' => $orderDirection
		);
		unset($fetchElements);
	
		if (!isset($socialForumFetchConditions['social_forum_ids']) || !empty($socialForumFetchConditions['social_forum_ids']))
		{
			$totalSocialForums = $socialForumModel->countSocialForumsInForum($forumId, $socialForumFetchConditions);
		}
		else
		{
			$totalSocialForums = 0;
		}
		
		$this->canonicalizePageNumber($page, $socialForumsPerPage, $totalSocialForums, 'social-forums', $forum);
	
		if ($totalSocialForums)
		{
			$socialForums = $socialForumModel->getSocialForumsInForum($forumId, $socialForumFetchConditions, $socialForumFetchOptions);
		}
		else
		{
			$socialForums = array();
		}
		
		if ($page == 1 && $totalSocialForums)
		{
			$stickySocialForumFetchOptions = $socialForumFetchOptions;
			unset($stickySocialForumFetchOptions['perPage'], $stickySocialForumFetchOptions['page']);
	
			$stickySocialForums = $socialForumModel->getStickySocialForumsInForum($forumId, $socialForumFetchConditions, $stickySocialForumFetchOptions);
		}
		else
		{
			$stickySocialForums = array();
		}
		
		$canCreateSocialForum = $forumModel->canCreateSocialForumInForum($forum);
		if ($totalSocialForums == 1 && !$canCreateSocialForum)
		{
			if (count($stickySocialForums))
			{
				return $this->responseRedirect(XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL, 
					XenForo_Link::buildPublicLink('social-forums', reset($stickySocialForums))
				);
			}
			else if (count($socialForums))
			{
				return $this->responseRedirect(XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
					XenForo_Link::buildPublicLink('social-forums', reset($socialForums))
				);
			}
		}
	
		// prepare all social groups for the social group list
		$inlineModOptions = array();
		$permissions = $visitor->getNodePermissions($forumId);
	
		foreach ($socialForums AS &$socialForum)
		{
//			$socialForumModOptions = $socialForumModel->addInlineModOptionToSocialForum($socialForum, $forum, $permissions);
//			$inlineModOptions += $socialForumModOptions;
	
			$socialForum = $socialForumModel->prepareSocialForum($socialForum, $forum, $permissions);
		}
		foreach ($stickySocialForums AS &$socialForum)
		{
//			$socialForumModOptions = $socialForumModel->addInlineModOptionToSocialForum($socialForum, $forum, $permissions);
//			$inlineModOptions += $socialForumModOptions;
	
			$socialForum = $socialForumModel->prepareSocialForum($socialForum, $forum, $permissions);
		}
		unset($socialForum);
		
		// if we've read everything on the first page of a normal sort order, probably need to mark as read
		if ($visitor['user_id'] && $page == 1 && !$displayConditions
		&& $order == 'last_post_date' && $orderDirection == 'desc'
		&& $forum['forum_read_date'] < $forum['last_post_date']
		)
		{
			$hasNew = false;
			foreach ($socialForums as $socialForum)
			{
				if ($socialForum['hasNew'])
				{
					$hasNew = true;
					break;
				}
			}
							
			if (!$hasNew)
			{
				// everything read, but forum not marked as read. Let's check.
				$this->_getForumModel()->markForumReadIfNeeded($forum);
			}

		
		}
		
		// get the ordering params set for the header links
		$orderParams = array();
		foreach ($this->_getSocialForumSortFields($forum) AS $field)
		{
			$orderParams[$field] = $displayConditions;
			$orderParams[$field]['order'] = ($field != $defaultOrder ? $field : false);
			if ($order == $field)
			{
				$orderParams[$field]['direction'] = ($orderDirection == 'desc' ? 'asc' : 'desc');
			}
		}
	
		$pageNavParams = $displayConditions;
		$pageNavParams['order'] = ($order != $defaultOrder ? $order : false);
		$pageNavParams['direction'] = ($orderDirection != $defaultOrderDirection ? $orderDirection : false);
		
		$viewParams = array(
			'nodeList' => $this->_getNodeModel()->getNodeDataForListDisplay($forum, 0),
			'forum' => $forum,
			'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum, false),

			'canCreateSocialForum' => $canCreateSocialForum,
			'canSearch' => $visitor->canSearch(),

			'inlineModOptions' => $inlineModOptions,
			'socialForums' => $socialForums,
			'stickySocialForums' => $stickySocialForums,

			'ignoredNames' => $this->_getIgnoredContentUserNames($socialForums) + $this->_getIgnoredContentUserNames($stickySocialForums),

			'order' => $order,
			'orderDirection' => $orderDirection,
			'orderParams' => $orderParams,
			'displayConditions' => $displayConditions,

			'pageNavParams' => $pageNavParams,
			'page' => $page,
			'socialForumStartOffset' => ($page - 1) * $socialForumsPerPage + 1,
			'socialForumEndOffset' => ($page - 1) * $socialForumsPerPage + count($socialForums) ,
			'socialForumsPerPage' => $socialForumsPerPage,
			'totalSocialForums' => $totalSocialForums,

			'showCreatedNotice' => $this->_input->filterSingle('created', XenForo_Input::UINT)
		);
	
		return $this->responseView('Waindigo_SocialGroups_ViewPublic_SocialCategory_View', 'waindigo_social_category_view_social_groups', $viewParams);
	}
	
	public function actionCreateSocialForum()
	{
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
	
		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);
	
		$forumId = $forum['node_id'];
	
		$this->_assertCanCreateSocialForumInForum($forum);
			
		$viewParams = array(
			'socialForum' => array(
				'social_forum_open' => 1,
			),
			'forum' => $forum,
			'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum),
			'member' => array(
				'is_social_forum_moderator' => 1,
			),

//			'watchState' => $this->_getThreadWatchModel()->getThreadWatchStateForVisitor(false),

// TODO: user can't do the following actions yet
//			'canLockUnlockThread' => $this->_getForumModel()->canLockUnlockThreadInForum($forum),
//			'canStickUnstickThread' => $this->_getForumModel()->canStickUnstickThreadInForum($forum),

		);
		return $this->responseView('Waindigo_SocialGroups_ViewPublic_SocialForum_Create', 'waindigo_social_forum_create_social_groups', $viewParams);
	}
	
	public function actionAddSocialForum()
	{
		$this->_assertPostOnly();
	
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);
	
		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);
	
		$forumId = $forum['node_id'];
	
		$this->_assertCanCreateSocialForumInForum($forum);
		
		$visitor = XenForo_Visitor::getInstance();
	
		$input = $this->_input->filter(array(
				'title' => XenForo_Input::STRING,
				'social_forum_open' => XenForo_Input::UINT,
				'social_forum_moderated' => XenForo_Input::UINT,
		));
		
		$input['user_id'] = $visitor['user_id'];
		
		$input['description'] = $this->getHelper('Editor')->getMessageText('description', $this->_input);
		$input['description'] = XenForo_Helper_String::autoLinkBbCode($input['description']);
		
		// note: assumes that the message dw will pick up the username issues
		$writer = XenForo_DataWriter::create('Waindigo_SocialGroups_DataWriter_SocialForum');
		$writer->bulkSet($input);
		$writer->set('node_id', $forumId);
		$writer->set('user_id', $visitor['user_id']);
		$writer->save();

		$socialForum = $writer->getMergedData();
		$return = XenForo_Link::buildPublicLink('social-forums', $socialForum);
	
		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			$return,
			new XenForo_Phrase('waindigo_your_social_forum_has_been_created_social_groups')
		);
	}
	
	protected function _getSocialForumFetchElements(array $forum, array $displayConditions)
	{
		$socialForumModel = $this->_getSocialForumModel();
		$visitor = XenForo_Visitor::getInstance();
	
// TODO: do we need some conditions here?
//		$socialForumFetchConditions = $displayConditions + $socialGroupModel->getPermissionBasedSocialGroupFetchConditions($forum);
		$socialForumFetchConditions = $displayConditions;
		
		if ($this->_routeMatch->getResponseType() != 'rss')
		{
			$socialForumFetchConditions += array('sticky' => 0);
		}
	
		$socialForumFetchOptions = array(
// TODO: do we need to join with user info?
//				'join' => Waindigo_SocialGroups_Model_SocialForum::FETCH_USER,
				'join' => Waindigo_SocialGroups_Model_SocialForum::FETCH_SOCIAL_MEMBER,
				'readUserId' => $visitor['user_id'],
// TODO: add the mini avatar if user is member of the group
//				'postCountUserId' => $visitor['user_id'],
		);
		if (!empty($socialForumFetchConditions['deleted']))
		{
			$socialForumFetchOptions['join'] |= Waindigo_SocialGroups_Model_SocialForum::FETCH_DELETION_LOG;
		}
		
		/* @var $socialCategoryModel Waindigo_SocialGroups_Model_SocialCategory */
		$socialCategoryModel = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialCategory');
		
		// if a user can't view all forums, then we find which ones they can
		if (!$socialCategoryModel->canViewSocialForums($forum))
		{
			/* @var $socialForumMemberModel Waindigo_SocialGroups_Model_SocialForumMember */
			$socialForumMemberModel = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForumMember');
			
			$socialForumMembers = $socialForumMemberModel->getSocialForumMembers(array(
				'user_id' => $visitor['user_id'],
			));
			
			$socialForumIds = array();
			/* @var $options XenForo_Options */
			$options = XenForo_Application::get('options');
			foreach ($socialForumMembers as $socialForumMember)
			{
				if (isset($options->waindigo_socialGroups_permissions[1]['viewSocialForum']) && ($options->waindigo_socialGroups_permissions[1]['viewSocialForum']
					|| ($socialForumMember['is_social_forum_moderator'] && $options->waindigo_socialGroups_permissions[2]['viewSocialForum'])
					|| ($socialForumMember['is_social_forum_creator'] && $options->waindigo_socialGroups_permissions[3]['viewSocialForum']))
				)
				{
					$socialForumIds[] = $socialForumMember['social_forum_id'];
				}
			}
			
			$socialForumFetchConditions['social_forum_ids'] = $socialForumIds;
		}
		
		return array(
				'conditions' => $socialForumFetchConditions,
				'options' => $socialForumFetchOptions
		);
	}
	
	protected function _getDefaultSocialForumSort(array $forum)
	{
		return array('title',  'asc');
	}
	
	protected function _getSocialForumSortFields(array $forum)
	{
		return array('title', 'last_post_date');
	}
	
	/**
	* Asserts that the currently browsing user can create a social forum in
	* the specified forum.
	*
	* @param array $forum
	*/
	protected function _assertCanCreateSocialForumInForum(array $forum)
	{
		if (!$this->_getForumModel()->canCreateSocialForumInForum($forum, $errorPhraseKey))
		{
			throw $this->getErrorOrNoPermissionResponseException($errorPhraseKey);
		}
	}
	
	/**
	 * Creates the specified helper class. If no underscore is present in the class
	 * name, "XenForo_ControllerHelper_" is prefixed. Otherwise, a full class name
	 * is assumed.
	 *
	 * @param string $class Full class name, or partial suffix (if no underscore)
	 *
	 * @return XenForo_ControllerHelper_Abstract
	 */
	public function getHelper($class)
	{
		if ($class == "ForumThreadPost")
		{
			$class = 'Waindigo_SocialGroups_ControllerHelper_SocialCategory';
		}
	
		return parent::getHelper($class);
	}
	
	/**
	* @return Waindigo_SocialGroups_Model_SocialForum
	*/
	protected function _getSocialForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');
	}

	/**
	* @return Waindigo_SocialGroups_Model_SocialCategory
	*/
	protected function _getForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialCategory');
	}
}