<?php

/**
 * Controller for handling actions on threads.
 */
class Waindigo_SocialGroups_ControllerPublic_Thread extends XFCP_Waindigo_SocialGroups_ControllerPublic_Thread
{
	public function actionIndex()
	{
		$response = parent::actionIndex();
	
		if (get_class($response) == "XenForo_ControllerResponse_View")
		{
			$thread = $response->params['thread'];
			if ($thread['social_forum_id'])
			{
				$response->params['forum']['social_forum_id'] = $thread['social_forum_id'];
				$response->params['forum']['social_forum_title'] = $thread['social_forum_title'];
				$response->params['socialForum'] = array('social_forum_id' => $thread['social_forum_id']);
				$this->_getForumModel()->markSocialForumReadIfNeeded($response->params['socialForum']);
			}
		}
	
		return $response;
	}
	
	protected function _getThreadForumFetchOptions()
	{
		$threadForumFetchOptions = parent::_getThreadForumFetchOptions();
		
		$threadForumFetchOptions[0]['join'] = 
			$threadForumFetchOptions[0]['join'] + 
			Waindigo_SocialGroups_Model_SocialForum::FETCH_SOCIAL_FORUM;
	
		return $threadForumFetchOptions;
	}
	
	public function getHelper($class)
	{
		if ($class == "ForumThreadPost")
		{
			$class = 'Waindigo_SocialGroups_ControllerHelper_SocialForumThreadPost';
		}
	
		return parent::getHelper($class);
	}		
	
	/**
	* @return Waindigo_SocialGroups_Model_SocialForum
	*/
	protected function _getForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');
	}	
}