<?php

/**
* Data writer for threads.
*
* @package XenForo_Discussion
*/
class Waindigo_SocialGroups_DataWriter_Discussion_Thread extends XFCP_Waindigo_SocialGroups_DataWriter_Discussion_Thread
{
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		$fields = parent::_getFields();
		$fields['xf_thread']['social_forum_id'] = array('type' => self::TYPE_UINT, 'default' => '0');
	
		return $fields;
	}
	
	protected function _discussionPreSave() {
		parent::_discussionPreSave();
		
		Waindigo_SocialGroups_SocialForum::getInstance()->processSocialGroups($this);
		
		if (isset($GLOBALS['Waindigo_SocialGroups_Model_Threads']))
		{
			$GLOBALS['Waindigo_SocialGroups_Model_Threads']->processSocialGroups($this);
		}
	}
	
	/**
	* Updates the necessary data in the container.
	*/
	protected function _updateContainerPostSave()
	{		
		if ($this->isUpdate() && $this->isChanged('social_forum_id'))
		{
			// this is a move. move is like: inserting into new container...
			if ($this->get('social_forum_id'))
			{
				$newContainerDw = $this->_getSocialForumDataWriter($this->get('social_forum_id'), $this->_errorHandler);
				if ($newContainerDw)
				{
					$newContainerDw->updateCountersAfterDiscussionSave($this, true);
					if ($newContainerDw->hasChanges())
					{
						$newContainerDw->save();
					}
				}
			}
				
			// ...and deleting from old container
			if ($this->getExisting('social_forum_id'))
			{
				$oldContainerDw = $this->_getSocialForumDataWriter($this->getExisting('social_forum_id'), $this->_errorHandler);
				if ($oldContainerDw)
				{
					$oldContainerDw->updateCountersAfterDiscussionDelete($this);
					if ($oldContainerDw->hasChanges())
					{
						$oldContainerDw->save();
					}
				}
			}
		}
		else
		{
			if ($this->get('social_forum_id'))
			{
				$containerDw = $this->_getSocialForumDataWriter($this->get('social_forum_id'), $this->_errorHandler);
				if ($containerDw)
				{
					$containerDw->updateCountersAfterDiscussionSave($this);
					if ($containerDw->hasChanges())
					{
						$containerDw->save();
					}
				}
			}
			else
			{
				parent::_updateContainerPostSave();
			}
		}
	}	
	
	/**
	 * Update container information after the main record has been deleted.
	 */
	protected function _updateContainerPostDelete()
	{
		if ($this->get('social_forum_id'))
		{
			$containerDw = $this->_getSocialForumDataWriter($this->get('social_forum_id'), $this->_errorHandler);
			if ($containerDw)
			{
				$containerDw->updateCountersAfterDiscussionDelete($this);
				if ($containerDw->hasChanges())
				{
					$containerDw->save();
				}
			}
			else
			{
				parent::_updateContainerPostDelete();
			}
		}
	}	

	protected function _getSocialForumDataWriter($socialForumId, $errorHandler)
	{
		$dw = XenForo_DataWriter::create('Waindigo_SocialGroups_DataWriter_SocialForum', $errorHandler);
		$dw->setExistingData($socialForumId);
		return $dw;
	}
}