<?php
class Waindigo_SocialGroups_DataWriter_ForumWatch extends XFCP_Waindigo_SocialGroups_DataWriter_ForumWatch
{
	protected $_socialGroupsDw;
	
	/**
	* @return boolean
	*/
	public function setExistingData($data, $trustInputAsPrimary = false)
	{
		if (isset($data['social_forum_id']))
		{
			$dw = XenForo_DataWriter::create('Waindigo_SocialGroups_DataWriter_SocialForumWatch');
			$dw->setExistingData($data, $trustInputAsPrimary);
			$this->_socialGroupsDw = $dw;
			return true;
		}
		return parent::setExistingData($data, $trustInputAsPrimary);
	}
	
	/**
	* @return boolean
	*/
	public function set($field, $value, $tableName = '', array $options = null)
	{
		if (!$this->_socialGroupsDw)
		{
			$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
			if (isset($socialForum['social_forum_id'])) {
				$dw = XenForo_DataWriter::create('Waindigo_SocialGroups_DataWriter_SocialForumWatch');
				$dw->set('social_forum_id', $socialForum['social_forum_id']);
				$this->_socialGroupsDw = $dw;
			}
		}
		if ($this->_socialGroupsDw)
		{
			if ($field != 'forum_id') $this->_socialGroupsDw->set($field, $value, $tableName, $options);
			return true;
		}
		else
		{
			return parent::set($field, $value, $tableName, $options);
		}
	}
	
	protected function _preSave()
	{
		if ($this->_socialGroupsDw)
		{
			$this->_errorHandler = ForumWatch_DataWriter_ForumWatch::ERROR_SILENT;
			$this->error('');
			$this->_socialGroupsDw->save();
		}
		else
		{
			parent::_preSave();
		}
	}
	
	protected function _preDelete()
	{
		if ($this->_socialGroupsDw)
		{
			$this->_errorHandler = ForumWatch_DataWriter_ForumWatch::ERROR_SILENT;
			$this->error('');
			$this->_socialGroupsDw->delete();
		}
		else
		{
			parent::_preDelete();
		}
	}
}