<?php
/**
* Data writer for Social Forum Members.
*/
class Waindigo_SocialGroups_DataWriter_SocialForumMember extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array('xf_social_forum_member' => array(
			'social_forum_member_id'	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
			'user_id'					=> array('type' => self::TYPE_UINT, 'required' => true),
			'social_forum_id'			=> array('type' => self::TYPE_UINT, 'required' => true),
			'is_social_forum_moderator' => array('type' => self::TYPE_BOOLEAN, 'default' => 0),
			'is_social_forum_creator'	=> array('type' => self::TYPE_BOOLEAN, 'default' => 0),
			'join_date'					=> array('type' => self::TYPE_UINT, 'default' => XenForo_Application::$time),
			'is_approved' 				=> array('type' => self::TYPE_BOOLEAN, 'default' => 0),
			'is_invited' 				=> array('type' => self::TYPE_BOOLEAN, 'default' => 0),
		));
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$socialForumMemberId = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		$socialForumMember = $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForumMember')->getSocialForumMemberById($socialForumMemberId);
		if (!$socialForumMember)
		{
			return false;
		}

		return $this->getTablesDataFromArray($socialForumMember);
	}
	
	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'social_forum_member_id = ' . $this->_db->quote($this->getExisting('social_forum_member_id'));
	}
	
	protected function _preSave()
	{
		if (($this->isChanged('is_approved') || $this->isChanged('is_invited')))
		{
			$this->_checkForumWatch();
		}
	}
	
	protected function _preDelete()
	{
		$this->_checkForumWatch(true);
	}
	
	protected function _checkForumWatch($isDelete = false)
	{
		$notifyOptions = XenForo_Application::get('options')->waindigo_socialGroups_notifyOptions;
		$forumWatch = array();
		if (class_exists('ForumWatch_Model_ForumWatch'))
		{
			/* @var $forumWatchModel ForumWatch_Model_ForumWatch */
			$forumWatchModel = XenForo_Model::create('ForumWatch_Model_ForumWatch');
			$forumWatch = $forumWatchModel->getUserForumWatchByForumId($this->get('user_id'), 0);
		}
		if ($this->get('is_approved') && !$this->get('is_invited') && !$isDelete)
		{
			if (isset($notifyOptions['default_watch_state']) && $notifyOptions['default_watch_state'])
			{
				if (class_exists('ForumWatch_DataWriter_ForumWatch'))
				{
					$dw = XenForo_DataWriter::create('ForumWatch_DataWriter_ForumWatch', XenForo_DataWriter::ERROR_SILENT);
					$dw->set('social_forum_id', $this->get('social_forum_id'));
					if (!empty($forumWatch))
					{
						$dw->setExistingData($forumWatch);
					}
					else
					{
						$dw->set('user_id', $this->get('user_id'));
					}
					$dw->set('reply_subscribe', 1);
					if ($notifyOptions['default_watch_state'] == 'watch_email')
					{
						$dw->set('notification_method', 2);
					}
					elseif ($notifyOptions['default_watch_state'] == 'watch_no_email')
					{
						$dw->set('notification_method', 1);
					}
					$dw->save();
				}
			}
		}
		else if (!empty($forumWatch))
		{
			$dw = XenForo_DataWriter::create('ForumWatch_DataWriter_ForumWatch', XenForo_DataWriter::ERROR_SILENT);
			$dw->set('social_forum_id', $this->get('social_forum_id'));
			$dw->setExistingData($forumWatch);
			$dw->delete();
		}
	}
}