<?php
class Waindigo_SocialGroups_DataWriter_SocialForumWatch extends XenForo_DataWriter
{
	protected function _getFields() {
		return array(
			'xf_social_forum_watch' => array(
				'user_id'          => array('type' => self::TYPE_UINT, 'required' => true),
				'social_forum_id'  => array('type' => self::TYPE_UINT, 'required' => true),
				'reply_subscribe'  => array('type' => self::TYPE_UINT, 'default' => 0),
				'notification_method'  => array('type' => self::TYPE_UINT, 'default' => 0),
			)
		);
	}

	protected function _getExistingData($data) {
		if (!is_array($data)) {
			return false;
		} else if (isset($data['user_id'], $data['social_forum_id'])) {
			$userId = $data['user_id'];
			$forumId = $data['social_forum_id'];
		} else if (isset($data[0], $data[1])) {
			$userId = $data[0];
			$forumId = $data[1];
		} else {
			return false;
		}

		return array('xf_social_forum_watch' => $this->_getForumWatchModel()->getUserForumWatchByForumId($userId, $forumId));
	}

	protected function _getUpdateCondition($tableName) {
		return 'user_id = ' . $this->_db->quote($this->getExisting('user_id'))
			. ' AND social_forum_id = ' . $this->_db->quote($this->getExisting('social_forum_id'));
	}

	protected function _getForumWatchModel() {
		return $this->getModelFromCache('ForumWatch_Model_ForumWatch');
	}
}