<?php

class Waindigo_SocialGroups_Install extends Waindigo_Install
{
	protected function _getTables()
	{
		return array(
			'xf_social_forum' => array(
				'social_forum_id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY',
				'node_id' => 'int(10) unsigned NOT NULL',
				'title' => 'varchar(150) NOT NULL DEFAULT \'\'',
				'description' => 'text NOT NULL',
				'discussion_count' => 'int(10) unsigned NOT NULL DEFAULT \'0\'',
				'message_count' => 'int(10) unsigned NOT NULL DEFAULT \'0\'',
				'sticky' => 'tinyint(3) unsigned NOT NULL DEFAULT \'0\'',
				'last_post_id' => 'int(10) unsigned NOT NULL DEFAULT \'0\' COMMENT \'Most recent post_id\'',
				'last_post_date' => 'int(10) unsigned NOT NULL DEFAULT \'0\' COMMENT \'Date of most recent post\'',
				'last_post_user_id' => 'int(10) unsigned NOT NULL DEFAULT \'0\' COMMENT \'User_id of user posting most recently\'',
				'last_post_username' => 'varchar(50) NOT NULL DEFAULT \'\' COMMENT \'Username of most recently-posting user\'',
				'last_thread_title' => 'varchar(150) NOT NULL DEFAULT \'\' COMMENT \'Title of thread most recent post is in\'',
				'moderate_messages' => 'tinyint(3) unsigned NOT NULL DEFAULT \'0\'',
				'allow_posting' => 'tinyint(3) unsigned NOT NULL DEFAULT \'1\'',
				'count_messages' => 'tinyint(3) unsigned NOT NULL DEFAULT \'1\' COMMENT \'If not set, messages posted (directly) within this forum will not contribute to user message totals.\'',
				'find_new' => 'tinyint(3) unsigned NOT NULL DEFAULT \'1\' COMMENT \'Include posts from this forum when running /find-new/threads\'',
				'social_forum_open' => 'tinyint(3) unsigned NOT NULL DEFAULT \'1\'',
				'social_forum_moderated' => 'tinyint(3) unsigned NOT NULL DEFAULT \'0\'',
				'logo_date' => 'INT(10) UNSIGNED NOT NULL DEFAULT \'0\'',
				'logo_width' => 'SMALLINT(5) UNSIGNED NOT NULL DEFAULT \'0\'',
				'logo_height' => 'SMALLINT(5) UNSIGNED NOT NULL DEFAULT \'0\'',
				'logo_crop_x' => 'INT(10) UNSIGNED NOT NULL DEFAULT \'0\' COMMENT \'X-Position from which to start the square crop on the m avatar\'',
				'logo_crop_y' => 'INT(10) UNSIGNED NOT NULL DEFAULT \'0\' COMMENT \'Y-Position from which to start the square crop on the m avatar\'',
				'user_id' => 'int(10) NOT NULL DEFAULT \'0\'',
				'created_date' => 'int(10) unsigned NOT NULL DEFAULT \'0\'',
			),
			'xf_social_forum_member' => array(
				'social_forum_member_id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY',
				'user_id' => 'int(10) NOT NULL',
				'social_forum_id' => 'int(10) NOT NULL',
				'is_social_forum_moderator' => 'tinyint(1) NOT NULL DEFAULT \'0\'',
				'is_social_forum_creator' => 'tinyint(1) NOT NULL DEFAULT \'0\'',
				'join_date' => 'int(10) NOT NULL',
				'is_approved' => 'tinyint(1) NOT NULL DEFAULT \'0\'',
				'is_invited' => 'tinyint(1) NOT NULL DEFAULT \'0\'',
			),
			'xf_social_forum_read' => array(
				'social_forum_read_id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY',
				'user_id' => 'int(10) unsigned NOT NULL',
				'social_forum_id' => 'int(10) unsigned NOT NULL',
				'social_forum_read_date' => 'int(10) unsigned NOT NULL',
			),
			'xf_social_forum_watch' => array(
				'user_id' => 'INT UNSIGNED NOT NULL',
				'social_forum_id' => 'INT UNSIGNED NOT NULL',
				'reply_subscribe' => 'TINYINT UNSIGNED NOT NULL DEFAULT 0',
				'notification_method' => 'TINYINT UNSIGNED NOT NULL DEFAULT 0',
			),
		);
	}
	
	protected function _getPrimaryKeys()
	{
		return array(
			'xf_social_forum_watch'	=> array('user_id', 'social_forum_id'),
		);
	}
	
	protected function _getUniqueKeys()
	{
		return array(
			'xf_social_forum_member' => array(
				'user_id_social_forum_id' => array('user_id', 'social_forum_id'),
			),
			'xf_social_forum_read' => array(
				'user_id_social_forum_id' => array('user_id', 'social_forum_id'),
			),
		);
	}

	protected function _getKeys()
	{
		return array(
			'xf_social_forum_read' => array(
				'social_forum_id' => array('social_forum_id'),
				'social_forum_read_date' => array('social_forum_read_date'),
			),
			'xf_thread' => array(
				'social_forum_id_last_post_date' => array('social_forum_id', 'last_post_date'),
				'social_forum_id_sticky_last_post_date' => array('social_forum_id', 'sticky', 'last_post_date'),
			),
			'xf_social_forum_watch' => array(
				'social_forum_id_reply_subscribe' => array('social_forum_id', 'reply_subscribe'),
			),
		);
	}
	
	protected function _getTableChanges()
	{
		return array(
			'xf_thread' => array(
				'social_forum_id' => 'INT(10) NOT NULL DEFAULT 0',
			),
			'xf_user_profile' => array(
				'primary_social_forum_id'    => 'INT(10) NOT NULL DEFAULT 0',
				'secondary_social_forum_ids' => 'VARCHAR(150) NOT NULL DEFAULT \'\'',
			),
		);
	}
	
	protected function _getNodeTypes()
	{
		return array(
			'SocialCategory' => array(
				'handler_class' => 'Waindigo_SocialGroups_NodeHandler_SocialCategory',
				'controller_admin_class' => 'Waindigo_SocialGroups_ControllerAdmin_SocialCategory',
				'datawriter_class' => 'Waindigo_SocialGroups_DataWriter_SocialCategory',
				'permission_group_id' => 'forum',
				'public_route_prefix' => 'social-categories',
			)
		);
	}
	
	protected function _getContentTypes()
	{
		return array(
			'social_forum' => array(
					'addon_id' => 'Waindigo_SocialGroups',
					'fields'   => array(
						'alert_handler_class' => 'Waindigo_SocialGroups_AlertHandler_SocialForum',
				)
			),
		);
	}
	
	protected function _isEWRportaEnabled()
	{
		$eventListeners = XenForo_CodeEvent::getEventListeners('load_class_model');
		if (!empty($eventListeners))
		{
			foreach ($eventListeners as $eventListener)
			{
				if ($eventListener[0] == "EWRporta_Listener_Model")
				{
					return true;
				}
			}
		}
		return false;
	}
	
	protected function _postInstall()
	{
		if ($this->_isEWRportaEnabled())
		{
			// Install XenPorta Block
			if (class_exists('EWRporta_Model_Blocks') && method_exists('EWRporta_Model_Blocks', 'installBlockXmlFromFile'))
			{
				$fileName = $this->getRootDir() . "/Waindigo/SocialGroups/XML/Waindigo_NewSocialForums.xml";
				$this->getModelFromCache('EWRporta_Model_Blocks')->installBlockXmlFromFile($fileName);
			}
		}
	}
	
	protected function _postUninstall()
	{
		if ($this->_isEWRportaEnabled())
		{
			// Uninstall XenPorta Block
			if (class_exists('EWRporta_Model_Blocks') && method_exists('EWRporta_Model_Blocks', 'uninstallBlock'))
			{
				$this->getModelFromCache('EWRporta_Model_Blocks')->uninstallBlock('Waindigo_SocialGroups');
			}
		}
	}
	
	protected function _postUninstallAfterTransaction()
	{
		if (class_exists('NodesAsTabs_Model_Options') &&
				method_exists('NodesAsTabs_Model_Options', 'deleteOrphans') &&
				method_exists('NodesAsTabs_Model_Options', 'rebuildCache'))
		{
			$optionsModel = XenForo_Model::create('NodesAsTabs_Model_Options');
		
			$optionsModel->deleteOrphans();
			$optionsModel->rebuildCache();
		}		
	}
}