<?php

class Waindigo_SocialGroups_Listener_LoadClassController extends Waindigo_Listener_LoadClass
{
	public static function loadClassController($class, array &$extend)
	{
		switch ($class)
		{
			case 'Waindigo_SocialGroups_ControllerAdmin_SocialCategory':
				if (file_exists(XenForo_Autoloader::getInstance()->autoloaderClassToFile('NodesAsTabs_ControllerAdmin_AllNodes')))
				{
					$db = XenForo_Application::get('db');
					if ($db->fetchOne('SELECT active FROM xf_addon WHERE addon_id = \'NodesAsTabs\''))
					{
						self::_extend('NodesAsTabs_ControllerAdmin_AllNodes', $extend);
					}
				}
				break;
			case 'XenForo_ControllerAdmin_Tools':
				XenForo_CacheRebuilder_Abstract::$builders['SocialGroups'] = 'Waindigo_SocialGroups_CacheRebuilder_SocialForum';
				break;				
			case 'XenForo_ControllerPublic_Thread':
				self::_extend('Waindigo_SocialGroups_ControllerPublic_Thread', $extend);
				break;
			case 'XenForo_ControllerPublic_Forum':
				self::_extend('Waindigo_SocialGroups_ControllerPublic_Forum', $extend);
				break;
			case 'XenForo_ControllerPublic_Post':
				self::_extend('Waindigo_SocialGroups_ControllerPublic_Post', $extend);
				break;
			case 'XenForo_ControllerPublic_Account':
				self::_extend('Waindigo_SocialGroups_ControllerPublic_Account', $extend);
				break;
			case 'XenForo_ControllerPublic_Member':
				self::_extend('Waindigo_SocialGroups_ControllerPublic_Member', $extend);
				break;
			case 'Waindigo_SocialGroups_ControllerPublic_SocialForum':
				if (file_exists(XenForo_Autoloader::getInstance()->autoloaderClassToFile('ForumWatch_Extend_ControllerPublic_Forum')))
				{
					self::_extend('ForumWatch_Extend_ControllerPublic_Forum', $extend);
					break;
				}
			case 'EWRatendo_ControllerPublic_Events':
				self::_extend('Waindigo_SocialGroups_ControllerPublic_Events', $extend);
				break;
		}
	}
}