<?php

class Waindigo_SocialGroups_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{
	public function run() {
		switch ($this->_hookName)
		{
			case 'thread_create_fields_extra':
				$this->_threadCreateFieldsExtra();
				break;
			case 'forum_view_pagenav_before':
				$this->_forumViewPagenavBefore();
				break;
			case 'account_personal_details_biometrics':
				$this->_accountPersonalDetailsBiometrics();
				break;
			case 'message_user_info_text':
				$this->_messageUserInfoText();
				break;
			case 'member_view_tabs_heading':
				$this->_memberViewTabsHeading();
				break;
			case 'member_view_tabs_content':
				$this->_memberViewTabsContent();
				break;
		}
		return parent::run();
	}
	
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		$templateHook = new Waindigo_SocialGroups_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
		$contents = $templateHook->run();
	}
	
	protected function _threadCreateFieldsExtra()
	{
		if (isset($this->_hookParams['forum']['social_forum_id']))
		{
			$this->_appendTemplate('waindigo_create_fields_extra_social_groups');
		}
	}

	protected function _forumViewPagenavBefore()
	{
		if (isset($this->_hookParams['forum']['social_forum_id']))
		{
			$this->_prependTemplate('waindigo_forum_view_threads_before_social_groups');
		}
	}
	
	protected function _accountPersonalDetailsBiometrics()
	{
		$xenOptions = XenForo_Application::get('options');
		if ($xenOptions->waindigo_socialGroups_primaryPostBit || $xenOptions->waindigo_socialGroups_secondaryPostBit)
		{
			$viewParams = $this->_fetchViewParams();
			$conditions = array(
				'user_id' => XenForo_Visitor::getUserId(),
			);
			$viewParams['socialForums'] = $this->_getSocialForumModel()->getSocialForums($conditions);
			if ($xenOptions->waindigo_socialGroups_secondaryPostBit)
			{
				$viewParams['visitor']['secondary_social_forum_ids'] = array_fill_keys(explode(",", $viewParams['visitor']['secondary_social_forum_ids']), 1);
			}
			$this->_prependTemplate('waindigo_account_social_forums_social_groups', $viewParams);
		}
	}
	
	protected function _messageUserInfoText()
	{
		$viewParams = $this->_fetchViewParams();
		if (!isset($viewParams['user']['post_id'])) return;
		if ($viewParams['user']['primary_social_forum_id'])
		{
			$socialForum = array(
				'social_forum_id' => $viewParams['user']['primary_social_forum_id'],		
				'logo_date' => $viewParams['user']['logo_date'],
				'logo_width' => $viewParams['user']['logo_width'],
				'logo_height' => $viewParams['user']['logo_height'],
				'logo_crop_x' => $viewParams['user']['logo_crop_x'],
				'logo_crop_y' => $viewParams['user']['logo_crop_y'],
			);
			$viewParams['user']['primary_social_forum_urls'] = Waindigo_SocialGroups_Template_Helper_SocialForum::getAvatarUrls($socialForum);
			$viewParams['user']['primarySocialForum'] = array(
				'social_forum_id' => $viewParams['user']['primary_social_forum_id'],
				'title' => $viewParams['user']['social_forum_title']
			);
		}
		if ($viewParams['user']['secondary_social_forum_ids'])
		{
			$viewParams['user']['secondary_social_forums'] = $this->_getSocialForumModel()->getSocialForums(array(
				'social_forum_ids' => explode(",",$viewParams['user']['secondary_social_forum_ids']),
			));
			foreach ($viewParams['user']['secondary_social_forums'] as &$socialForum)
			{
				$socialForum['urls'] = Waindigo_SocialGroups_Template_Helper_SocialForum::getAvatarUrls($socialForum);
			}
		}
		$this->_appendTemplateAtSlot('message_user_info_text', 'waindigo_message_user_info_social_groups', $viewParams);
	}
	
	protected function _memberViewTabsHeading()
	{
		$this->_appendTemplate('waindigo_member_view_tabs_heading_social_groups');
	}
	
	protected function _memberViewTabsContent()
	{
		$this->_appendTemplate('waindigo_member_view_tabs_content_social_groups');
	}
	
	/**
	 * @return Waindigo_SocialGroups_Model_SocialForum
	 */
	protected function _getSocialForumModel()
	{
		return XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForum');
	}	
}