<?php

class Waindigo_SocialGroups_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{	
	public function run() {
		switch ($this->_templateName)
		{
			case 'waindigo_social_forum_view_social_groups':
				$this->_socialForumView();
				break;
			case 'forum_view':
				$this->_forumView();
				break;
			case 'thread_prefix_edit':
			case 'thread_field_edit':
			case 'post_field_edit':
				$this->_threadPrefixEdit();
				break;
			case 'PAGE_CONTAINER':
				$this->_pageContainer();
				break;
			case 'tools_rebuild':
				$this->_toolsRebuild();
				break;				
		}
		return parent::run();
	}
	
	public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
	{
		$templatePostRender = new Waindigo_SocialGroups_Listener_TemplatePostRender($templateName, $content, $containerData, $template);
		list($content, $containerData) = $templatePostRender->run();
	}
	
	protected function _forumView()
	{
		if (!XenForo_Application::get('options')->waindigo_socialGroups_showSidebar)
		{
			$GLOBALS['forum_view'] = true;
		}
		
		$this->_appendTemplateAtDomQuery('.pageNavLinkGroup .linkGroup', 'waindigo_social_forum_options_social_groups');
	}
	
	protected function _socialForumView()
	{	
		// XenAtendo
		if (XenForo_Permission::hasPermission(XenForo_Visitor::getInstance()->permissions, 'EWRatendo', 'canPost'))
		{
			EWRatendo_Listener_Template::template_post_render('forum_view', $this->_contents, $this->_containerData, $this->_template);
		}
		
		// Forum Watch
		if (class_exists('ForumWatch_Listener'))
		{
			ForumWatch_Listener::template_post_render('forum_view', $this->_contents, $this->_containerData, $this->_template);
		}
		
		$this->_appendTemplateAtDomQuery('.pageNavLinkGroup .linkGroup', 'waindigo_social_forum_options_social_groups');
	}
	
	protected function _threadPrefixEdit()
	{
		$viewParams = $this->_fetchViewParams();

		$dom = new Zend_Dom_Query($this->_utf8Decode($this->_contents));
		$nodeSelect = $dom->query('#ApplicableForums dl select option');
		foreach ($nodeSelect as $nodeSelectItem)
		{
			/* @var $nodeSelectItem DOMElement */
			$nodeId = $nodeSelectItem->getAttribute('value');
			if (isset($viewParams['nodes'][$nodeId]) && $viewParams['nodes'][$nodeId]['node_type_id'] == 'SocialCategory')
			{
				$nodeSelectItem->removeAttribute('disabled');
			}
		}
		$this->_contents = $this->_utf8Encode($nodeSelect->getDocument()->saveHTML());
	}
	
	protected function _pageContainer()
	{
		if (isset($GLOBALS['forum_view']))
		{
			$viewParams = $this->_fetchViewParams();
			/* @var $socialForum Waindigo_SocialGroups_SocialForum */
			$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
			if (isset($socialForum['social_forum_id']))
			{
				$viewParams['socialForum'] = $socialForum;
				$visitor = XenForo_Visitor::getInstance();
				if (isset($visitor['user_id']))
				{
					$member = $socialForum->getMember();
					if (!array_key_exists('social_forum_member_id', $member) && $this->_getSocialForumModel()->canJoinSocialForum($socialForum))
					{
						$this->_appendTemplateAfterTopCtrl('waindigo_join_social_forum_topctrl_social_groups', $viewParams);
					}
					else if ($member['is_invited'])
					{
						$this->_appendTemplateAfterTopCtrl('waindigo_accept_invite_topctrl_social_groups', $viewParams);
					}
				}
			}
		}
	}
	
	protected function _toolsRebuild()
	{
		$this->_appendTemplate('waindigo_tools_rebuild_social_groups');
	}
	
	/**
	 * @return Waindigo_SocialGroups_Model_SocialForum
	 */
	protected function _getSocialForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');
	}	
}