<?php

class Waindigo_SocialGroups_Model_Events extends XFCP_Waindigo_SocialGroups_Model_Events
{

	public function getCurrentEvents($range = '+1 week', $nodeid = false, $stream = false, $thread = true)
	{
		$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
		
		if (isset($socialForum['social_forum_id']))
		{
			if (!$events = $this->_getDb()->fetchAll("
					SELECT EWRatendo_events.*, xf_user.*, xf_thread.*, EWRatendo_services.service_slug,
						IF(xf_user.username IS NULL, EWRatendo_events.username, xf_user.username) AS username
					FROM EWRatendo_events
						LEFT JOIN EWRatendo_services ON (EWRatendo_services.service_id = EWRatendo_events.service_id)
						LEFT JOIN xf_user ON (xf_user.user_id = EWRatendo_events.user_id)
						LEFT JOIN xf_thread ON (xf_thread.thread_id = EWRatendo_events.thread_id)
					WHERE EWRatendo_events.event_endtime >= ?
						AND EWRatendo_events.event_strtime <= ?
						AND EWRatendo_events.event_state = 'visible'
					". ($thread ? 'AND EWRatendo_events.thread_id != "0"' : '') ."
					". ($stream ? 'AND EWRatendo_events.service_id != "0"' : '') ."
					". ($nodeid ? 'AND xf_thread.node_id = "'.$nodeid.'"' : '') ."
						AND social_forum_id = ?
					". ($stream ? 'GROUP BY service_id, service_value, service_value2' : '') ."
					ORDER BY EWRatendo_events.event_strtime ASC
				", array(XenForo_Application::$time, strtotime($range), $socialForum['social_forum_id'])))
			{
				return false;
			}
	
			foreach ($events AS &$event)
			{
				$event = $this->formatDates($event);
			}
		
			return $events;
		}
		
		return parent::getCurrentEvents($range, $nodeid, $stream, $thread);
	}
}