<?php

class Waindigo_SocialGroups_Model_Forum extends XFCP_Waindigo_SocialGroups_Model_Forum
{
	/**
	 * Determines if a new attachment can be posted in the specified forum,
	 * with the given permissions. If no permissions are specified, permissions
	 * are retrieved from the currently visiting user. This does not check viewing permissions.
	 *
	 * @param array $forum Info about the forum posting in
	 * @param string $errorPhraseKey Returned phrase key for a specific error
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return boolean
	 */
	public function canUploadAndManageAttachment(array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
		if ($forum['node_type_id'] == 'SocialCategory' && !isset($socialForum['social_forum_id']))
		{
			$socialForumMember = $this->_getSocialForumMemberModel()->getMaximumMembershipForUserId(XenForo_Visitor::getUserId());
			// TODO: Need to check whether a user can upload an attachment for a specific group
			$nodePermissions = XenForo_Application::get('options')->waindigo_socialGroups_permissions[$socialForumMember['level']];
		}
		
		return parent::canUploadAndManageAttachment($forum, $errorPhraseKey, $nodePermissions, $viewingUser);
	}
	
	/**
	* @return Waindigo_SocialGroups_Model_SocialForumMember
	*/
	protected function _getSocialForumMemberModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForumMember');
	}	
}