<?php
class Waindigo_SocialGroups_Model_ForumWatch extends XFCP_Waindigo_SocialGroups_Model_ForumWatch {
	
	public function getUserForumWatchByForumId($userId, $forumId) {
		$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
		
		if (isset($socialForum['social_forum_id']))
		{
			return $this->_getDb()->fetchRow('
				SELECT *
				FROM xf_social_forum_watch
				WHERE user_id = ?
					AND social_forum_id = ?
			', array($userId, $socialForum['social_forum_id']));
		}
		else
		{
			return parent::getUserForumWatchByForumId($userId, $forumId);
		}
	}
	
	public function getUsersWatchingForum($forumId, $threadId = 0) {
		$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();
		
		if (isset($socialForum['social_forum_id']))
		{
			static $caches = array();
		
			$autoReadDate = XenForo_Application::$time - (XenForo_Application::get('options')->readMarkingDataLifetime * 86400);
		
			$hash = "$forumId|$threadId";
			if (!isset($caches[$hash])) {
				$caches[$hash] = $this->fetchAllKeyed('
					SELECT user.*,
					user_option.*,
					user_profile.*,
					social_forum_watch.reply_subscribe, social_forum_watch.notification_method,
					permission.cache_value AS node_permission_cache,
					social_forum_member.is_approved, social_forum_member.is_invited, social_forum_member.is_social_forum_moderator, social_forum_member.is_social_forum_creator,
					GREATEST(COALESCE(thread_read.thread_read_date, 0), COALESCE(social_forum_read.social_forum_read_date, 0), ' . $autoReadDate . ') AS thread_read_date
					FROM xf_social_forum_watch AS social_forum_watch
					INNER JOIN xf_user AS user ON
					(user.user_id = social_forum_watch.user_id AND user.user_state = \'valid\' AND user.is_banned = 0)
					INNER JOIN xf_user_option AS user_option ON
					(user_option.user_id = user.user_id)
					INNER JOIN xf_user_profile AS user_profile ON
					(user_profile.user_id = user.user_id)
					LEFT JOIN xf_social_forum AS social_forum
					ON (social_forum.social_forum_id = social_forum_watch.social_forum_id)
					LEFT JOIN xf_permission_cache_content AS permission
					ON (permission.permission_combination_id = user.permission_combination_id
					AND permission.content_type = \'node\'
					AND permission.content_id = social_forum.node_id)
					LEFT JOIN xf_thread_read AS thread_read
					ON (thread_read.thread_id = ? AND thread_read.user_id = user.user_id)
					LEFT JOIN xf_social_forum_read AS social_forum_read
					ON (social_forum_read.social_forum_id = social_forum_watch.social_forum_id AND social_forum_read.user_id = user.user_id)
					LEFT JOIN xf_social_forum_member AS social_forum_member
					ON (social_forum_member.social_forum_id = social_forum_watch.social_forum_id AND social_forum_member.user_id = user.user_id)
					WHERE social_forum_watch.social_forum_id = ? AND social_forum_member.is_approved AND !social_forum_member.is_invited
				', 'user_id', array($threadId, $socialForum['social_forum_id']));
				
				/* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
				$socialForumModel = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForum');
				foreach ($caches[$hash] as $userId => $user)
				{
					$caches[$hash][$userId]['node_permission_cache'] = 
						serialize($socialForumModel->getSocialForumPermissions(
								$caches[$hash][$userId],
								unserialize($caches[$hash][$userId]['node_permission_cache'])
						));
				}
			}
		
			return $caches[$hash];
		}
		return parent::getUsersWatchingForum($forumId, $threadId);
	}
	
	public function sendNotificationToWatchUsersOnNewThread(array $thread, /* array */ $forum, array $post) {
		$socialForum = Waindigo_SocialGroups_SocialForum::getInstance();

		if (isset($socialForum['social_forum_id']))
		{
			if (!isset($forum))
			{
				$forum = $socialForum->toArray();
			}
			if (isset($forum))
			{
				$forum['title'] = $forum['social_forum_title'];
			}
		}
		return parent::sendNotificationToWatchUsersOnNewThread($thread, $forum, $post);
	}
}