<?php

/**
 * Permission model.
 */
class Waindigo_SocialGroups_Model_Permission extends XFCP_Waindigo_SocialGroups_Model_Permission
{
	/**
	 * Gets the permissions in the specified group.
	 *
	 * @param string $permissionId
	 *
	 * @return array Format: [permission id] => info
	 */
	public function getPermissionByGroup($permissionGroupId)
	{
		return $this->fetchAllKeyed('
			SELECT *
			FROM xf_permission
			WHERE permission_group_id = ' . $this->_getDb()->quote($permissionGroupId) . '
			AND permission_type = \'flag\'
			ORDER BY interface_group_id DESC, display_order ASC
		', 'permission_id');
	}
	
	public function getSocialGroupsPreparedOption(array $preparedOption)
	{
		$preparedOption['count'] = array(1, 2, 3);
		
		$permissions = $this->getPermissionByGroup('forum');
		
		foreach ($permissions as $permissionId => $permission)
		{
			if ($permissionId != "createSocialForum" && $permissionId != "joinSocialForum")
			{
				$preparedOption['permissions'][$permissionId] = new XenForo_Phrase('permission_forum_' . $permissionId);
			}
		}
		
		return $preparedOption;
	}
}