<?php

/**
 * Model for users.
 */
class Waindigo_SocialGroups_Model_Post extends XFCP_Waindigo_SocialGroups_Model_Post
{
	/**
	 * Prepares join-related fetch options.
	 *
	 * @param array $fetchOptions
	 *
	 * @return array Containing 'selectFields' and 'joinTables' keys.
	 */
	public function preparePostJoinOptions(array $fetchOptions)
	{
		$userFetchOptions = parent::preparePostJoinOptions($fetchOptions);

		$selectFields = $userFetchOptions['selectFields'];
		$joinTables = $userFetchOptions['joinTables'];
	
		if (!empty($fetchOptions['join']))
		{
			if ($fetchOptions['join'] & self::FETCH_USER_PROFILE)
			{
				$selectFields .= ',
					social_forum.logo_date,
					social_forum.logo_width,
					social_forum.logo_height,
					social_forum.logo_crop_x,
					social_forum.logo_crop_y,
					social_forum.title AS social_forum_title';
				$joinTables .= '
					LEFT JOIN xf_social_forum AS social_forum ON
					(social_forum.social_forum_id = user_profile.primary_social_forum_id)';
			}
			else if ($fetchOptions['join'] & self::FETCH_FORUM)
			{
				$selectFields .= ',
					IF(thread.social_forum_id, social_forum.title, node.title) AS node_title';
				$joinTables .= '
					LEFT JOIN xf_social_forum AS social_forum ON
					(social_forum.social_forum_id = thread.social_forum_id)';
			}				
		}
		
		return array(
				'selectFields' => $selectFields,
				'joinTables'   => $joinTables
		);		
	}
	
	/**
	 * Determines if the post can be viewed with the given permissions.
	 * TThis will check that any parent container can be viewed as well.
	 *
	 * @param array $post Info about the post
	 * @param array $thread Info about the thread this post is in
	 * @param array $forum Info about the forum the thread is in
	 * @param string $errorPhraseKey Returned phrase key for a specific error
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return boolean
	 */
	public function canViewPostAndContainer(array $post, array $thread, array $forum, &$errorPhraseKey = '',
		array $nodePermissions = null, array $viewingUser = null
	)
	{
		if (isset($thread['social_forum_id']) && $thread['social_forum_id'])
		{
			$socialForum = Waindigo_SocialGroups_SocialForum::setup($thread['social_forum_id']);

			/* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
			$socialForumModel = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForum');
			
			$nodePermissions = $socialForumModel->getNodePermissions($socialForum->toArray(), $socialForum->getSocialForumMembers());
			XenForo_Visitor::getInstance()->setNodePermissions($forum['node_id'], $nodePermissions);
		}
		
		return parent::canViewPostAndContainer($post, $thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser);
	}
	
	/**
	 * Determines if an attachment on this post can be viewed.
	 * This does not check post viewing permissions.
	 *
	 * @param array $post Info about the post
	 * @param array $thread Info about the thread this post is in
	 * @param array $forum Info about the forum the thread is in
	 * @param string $errorPhraseKey Returned phrase key for a specific error
	 * @param array|null $nodePermissions
	 * @param array|null $viewingUser
	 *
	 * @return boolean
	 */
	public function canViewAttachmentOnPost(array $post, array $thread, array $forum, &$errorPhraseKey = '', array $nodePermissions = null, array $viewingUser = null)
	{
		if (isset($thread['social_forum_id']) && $thread['social_forum_id'])
		{
			$socialForum = Waindigo_SocialGroups_SocialForum::setup($thread['social_forum_id']);

			/* @var $socialForumModel Waindigo_SocialGroups_Model_SocialForum */
			$socialForumModel = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForum');
			
			$nodePermissions = $socialForumModel->getNodePermissions($socialForum->toArray(), $socialForum->getSocialForumMembers());
			XenForo_Visitor::getInstance()->setNodePermissions($forum['node_id'], $nodePermissions);
		}
		
		return parent::canViewAttachmentOnPost($post, $thread, $forum, $errorPhraseKey, $nodePermissions, $viewingUser);
	}
}		