<?php

/**
 * Route prefix handler for social forums in the public system.
 */
class Waindigo_SocialGroups_Route_Prefix_SocialForums implements XenForo_Route_Interface
{
	/**
	 * Standard approach to caching model objects for the lifetime of the data writer.
	 * This is now a static cache to allow data to be reused between data writers, as they
	 * are often used in bulk.
	 *
	 * @var array
	 */
	protected static $_modelCache = array();
	
	/**
	 * Match a specific route for an already matched prefix.
	 *
	 * @see XenForo_Route_Interface::match()
	 */
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
		$action = $router->resolveActionWithIntegerParam($routePath, $request, 'social_forum_id');
		$action = $router->resolveActionAsPageNumber($action, $request);
		return $router->getRouteMatch('Waindigo_SocialGroups_ControllerPublic_SocialForum', $action, 'forums');
	}

	/**
	 * Method to build a link to the specified page/action with the provided
	 * data and params.
	 *
	 * @see XenForo_Route_BuilderInterface
	 */
	public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
	{
		if (isset($data['social_forum_title']))
		{
			$data['title'] = $data['social_forum_title'];
		}
		return XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix, $action, $extension, $data, 'social_forum_id', 'title');
	}
	
	/**
	 * Gets the social forum model object.
	 *
	 * @return Waindigo_SocialGroups_Model_SocialForum
	 */
	protected function _getSocialForumModel()
	{
		return $this->getModelFromCache('Waindigo_SocialGroups_Model_SocialForum');
	}
	
	/**
	* Gets the specified model object from the cache. If it does not exist,
	* it will be instantiated.
	*
	* @param string $class Name of the class to load
	*
	* @return XenForo_Model
	*/
	public function getModelFromCache($class)
	{
		if (!isset(self::$_modelCache[$class]))
		{
			self::$_modelCache[$class] = XenForo_Model::create($class);
		}
	
		return self::$_modelCache[$class];
	}	
}