<?php

class Waindigo_SocialGroups_SocialForum implements ArrayAccess
{
	/**
	* Instance manager.
	*
	* @var Waindigo_SocialGroups_SocialForum
	*/
	private static $_instance;
	
	/**
	* Array of social forum info.
	*
	* @var array
	*/
	protected $_socialForum = array();
	
	/**
	 * Array of social forum members.
	 *
	 * @var array
	 */
	protected $_members = array();
	
	/**
	* Protected constructor. Use {@link getInstance()} instead.
	*/
	protected function __construct()
	{
	}

	/**
	* Gets the browsing user's info.
	*
	* @return Waindigo_SocialGroups_SocialForum
	*/
	public static final function getInstance()
	{
		if (!self::$_instance)
		{
			self::setup(array()); // setup sets the instance
		}

		return self::$_instance;
	}

	/**
	* Determines if we have a visitor instance setup.
	*
	* @return boolean
	*/
	public static function hasInstance()
	{
		return (self::$_instance ? true : false);
	}
	
	/**
	* Gets the social forum info in array format (for areas that require actual arrays).
	*
	* @return array
	*/
	public function toArray()
	{
		return $this->_socialForum;
	}
	
	/**
	* Setup the social forum singleton.
	*
	* @param integer $socialForum Social forum to setup as
	*
	* @return Waindigo_SocialGroups_SocialForum
	*/
	public static function setup($socialForum)
	{
		$visitor = XenForo_Visitor::getInstance();		
		$object = new self();

		$fetchOptions = array('readUserId' => $visitor['user_id']);
		
		if (is_array($socialForum))
		{
			$object->_socialForum = $socialForum;
		}
		else if ($socialForum)
		{
			$object->_socialForum = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForum')->getSocialForumById($socialForum, $fetchOptions);
		}
		
		if (!isset($object->_socialForum['social_forum_title']) && isset($object->_socialForum['title']))
		{
			$object->_socialForum['social_forum_title'] = $object->_socialForum['title'];
		}
			
		if (isset($object->_socialForum['social_forum_id']))
		{
			$object->_members = XenForo_Model::create('Waindigo_SocialGroups_Model_SocialForumMember')->getSocialForumUsers(
				array('social_forum_id' => $object->_socialForum['social_forum_id'])
			);
		}
				
		self::$_instance = $object;
	
		return self::$_instance;
	}
	
	public function getSocialForumMembers()
	{
		return $this->_members;
	}
	
	public function getMember()
	{
		$visitor = XenForo_Visitor::getInstance();
		
		$members = $this->getSocialForumMembers();
		
		if (array_key_exists($visitor['user_id'], $members))
		{
			return $members[$visitor['user_id']];
		}
		
		return array(
			'is_social_forum_moderator' => false,
			'is_approved' => false,
			'is_social_forum_creator' => false,
			'is_invited' => false,
		);
	}
	
	public function processSocialGroups(XenForo_DataWriter_Discussion_Thread $dw)
	{
		if (isset($this->_socialForum['social_forum_id']))
		{
			$dw->set('social_forum_id', $this->_socialForum['social_forum_id']);
		}
	}
	
	/**
	* For ArrayAccess.
	*
	* @param string $offset
	*/
	public function offsetExists($offset)
	{
		return isset($this->_socialForum[$offset]);
	}
	
	/**
	 * For ArrayAccess.
	 *
	 * @param string $offset
	 */
	public function offsetGet($offset)
	{
		return $this->_socialForum[$offset];
	}
	
	/**
	 * For ArrayAccess.
	 *
	 * @param string $offset
	 * @param mixed $value
	 */
	public function offsetSet($offset, $value)
	{
		$this->_socialForum[$offset] = $value;
	}
	
	/**
	 * For ArrayAccess.
	 *
	 * @param string $offset
	 */
	public function offsetUnset($offset)
	{
		unset($this->_socialForum[$offset]);
	}
}	