<?php

/**
 * View handling for viewing the details of a specific social forum.
 */
class Waindigo_SocialGroups_ViewPublic_SocialForum_View extends XenForo_ViewPublic_Forum_View
{
	/**
	 * Help render the HTML output.
	 *
	 * @return mixed
	 */
	public function renderHtml()
	{
		parent::renderHtml();

		$this->_params['urls'] = Waindigo_SocialGroups_Template_Helper_SocialForum::getAvatarUrls($this->_params['socialForum']);
		
		$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create('Base', array('view' => $this)));
		$this->_params['socialForum']['description'] = new XenForo_BbCode_TextWrapper($this->_params['socialForum']['description'], $bbCodeParser);
	}
}
