<?php

/**
 *
 * @see XenForo_DataWriter_Discussion_Thread
 */
class Waindigo_ThreadBumpManage_Extend_XenForo_DataWriter_Discussion_Thread extends XFCP_Waindigo_ThreadBumpManage_Extend_XenForo_DataWriter_Discussion_Thread
{

    /**
     *
     * @see XenForo_DataWriter_Discussion_Thread::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();

        $fields['xf_thread']['last_bump_date_waindigo'] = array(
            'type' => self::TYPE_UINT,
            'default' => XenForo_Application::$time
        );
        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenForo_DataWriter_Discussion_Thread::_discussionPreSave()
     */
    protected function _discussionPreSave()
    {
        if ($this->isUpdate() && $this->isChanged('last_post_date')) {
            $bumpDate = $this->get('last_bump_date_waindigo');
            $bumpDateMin = XenForo_Application::get('options')->waindigo_threadBumpManage_minumumBumpTime * 60;
            if ($bumpDate <= XenForo_Application::$time - $bumpDateMin) {
                $this->set('last_bump_date_waindigo', XenForo_Application::$time);
            }
        }
        return parent::_discussionPreSave();
    } /* END _discussionPreSave */
}