<?php

/**
 *
 * @see XenForo_Model_Thread
 */
class Waindigo_ThreadBumpManage_Extend_XenForo_Model_Thread extends XFCP_Waindigo_ThreadBumpManage_Extend_XenForo_Model_Thread
{

    /**
     *
     * @see XenForo_Model_Thread::prepareThreadFetchOptions()
     */
    public function prepareThreadFetchOptions(array $fetchOptions)
    {
        $selectFields = '';
        $joinTables = '';
        $orderBy = '';

        if (!empty($fetchOptions['order'])) {
            switch ($fetchOptions['order']) {
                case 'last_bump_date_waindigo':
                    $orderBy = 'thread.last_bump_date_waindigo';
                    break;
            }
            if ($orderBy) {
                if (!isset($fetchOptions['orderDirection']) || $fetchOptions['orderDirection'] == 'desc') {
                    $orderBy .= ' DESC';
                } else {
                    $orderBy .= ' ASC';
                }
            }
        }

        $threadFetchOptions = parent::prepareThreadFetchOptions($fetchOptions);

        return array(
            'selectFields' => $threadFetchOptions['selectFields'] . $selectFields,
            'joinTables' => $joinTables . $threadFetchOptions['joinTables'],
            'orderClause' => ($orderBy ? "ORDER BY $orderBy" : $threadFetchOptions['orderClause'])
        );
    } /* END prepareThreadFetchOptions */
}