<?php

/**
 *
 * @see XenForo_ControllerPublic_Forum
 */
class Waindigo_ThreadFilters_Extend_XenForo_ControllerPublic_Forum extends XFCP_Waindigo_ThreadFilters_Extend_XenForo_ControllerPublic_Forum
{

    /**
     *
     * @see XenForo_ControllerPublic_Forum::actionForum()
     */
    public function actionForum()
    {
        $response = parent::actionForum();

        $this->_filterCheck();

        $defaultMembers = '';
        $members = $this->_input->filterSingle('members', XenForo_Input::STRING,
            array(
                'default' => $defaultMembers
            ));
        $response->params['members'] = $members;

        if (isset($response->params['pageNavParams']['membersArray'])) {
            $searchType = $this->_input->filterSingle('search_type', XenForo_Input::STRING);
            $response->params['membersArray'] = $response->params['pageNavParams']['membersArray'];
            $response->params['pageNavParams']['search_type'] = $searchType;
            $response->params['pageNavParams']['members'] = $members;
            unset($response->params['pageNavParams']['membersArray']);
            unset($response->params['pageNavParams']['user_id']);
            unset($response->params['pageNavParams']['waindigoThreadUserId']);
        }

        if (isset($response->params['pageNavParams']['prefixes'])) {
            unset($response->params['pageNavParams']['prefix_id']);
            unset($response->params['displayConditions']['prefix_id']);
            $response->params['prefixArray'] = $response->params['pageNavParams']['prefixArray'];
            unset($response->params['pageNavParams']['prefixArray']);
        }

        return $response;
    } /* END actionForum */

    /**
     *
     * @see Waindigo_ForumDigest_Extend_XenForo_ControllerPublic_Forum::actionDigest()
     */
    public function actionDigest()
    {
        $response = parent::actionDigest();

        $this->_filterCheck();

        $defaultMembers = '';
        $members = $this->_input->filterSingle('members', XenForo_Input::STRING,
            array(
                'default' => $defaultMembers
            ));
        $response->params['members'] = $members;

        if (isset($response->params['pageNavParams']['membersArray'])) {
            $searchType = $this->_input->filterSingle('search_type', XenForo_Input::STRING);
            $response->params['membersArray'] = $response->params['pageNavParams']['membersArray'];
            $response->params['pageNavParams']['search_type'] = $searchType;
            unset($response->params['pageNavParams']['membersArray']);
            unset($response->params['pageNavParams']['user_id']);
            unset($response->params['pageNavParams']['waindigoThreadUserId']);
        }

        if (isset($response->params['pageNavParams']['prefixes'])) {
            unset($response->params['pageNavParams']['prefix_id']);
            unset($response->params['displayConditions']['prefix_id']);
            $response->params['prefixArray'] = $response->params['pageNavParams']['prefixArray'];
            unset($response->params['pageNavParams']['prefixArray']);
        }

        return $response;
    } /* END actionDigest */

    /**
     *
     * @see XenForo_ControllerPublic_Forum::_getThreadFetchElements()
     */
    protected function _getThreadFetchElements(array $forum, array $displayConditions)
    {
        $fetchElements = parent::_getThreadFetchElements($forum, $displayConditions);

        if (isset($displayConditions['waindigoThreadUserId'])) {
            $fetchElements['options']['waindigoThreadUserId'] = $displayConditions['waindigoThreadUserId'];
        }

        return $fetchElements;
    } /* END _getThreadFetchElements */

    /**
     *
     * @see XenForo_ControllerPublic_Forum::_getDisplayConditions()
     */
    protected function _getDisplayConditions(array $forum)
    {
        $displayConditions = parent::_getDisplayConditions($forum);

        $members = $this->_input->filterSingle('members', XenForo_Input::STRING);
        $searchType = $this->_input->filterSingle('search_type', XenForo_Input::STRING);
        if ($members) {
            $usernames = explode(',', $members);
            $users = $this->_getUsersFromInput($usernames);
            $usernames = array();
            foreach ($users as $userId => $user) {
                $usernames[$userId] = $user['username'];
            }
            if ($searchType == 'posted_by_member' || $searchType == 'posted_in_by_member') {
                foreach ($users as $key => $user) {
                    $tempMembers = $usernames;
                    $displayConditions['membersArray'][$key]['username'] = $user['username'];
                    unset($tempMembers[$key]);
                    $displayConditions['membersArray'][$key]['memberSearch'] = implode(',', $tempMembers);
                }
            }
            if ($searchType == 'posted_by_member') {
                $displayConditions['user_id'] = array_keys($users);
            }
            if ($searchType == 'posted_in_by_member') {
                $displayConditions['waindigoThreadUserId'] = array_keys($users);
            }
        }

        $prefixesArray = $this->_input->filterSingle('prefixes', XenForo_Input::ARRAY_SIMPLE);
        if ($prefixesArray) {
            if (count($prefixesArray) != 1) {
                $displayConditions['prefix_id'] = $prefixesArray;
                $displayConditions['prefixes'] = $prefixesArray;
                foreach ($prefixesArray as $key => $prefix) {
                    $tempPrefixes = $prefixesArray;
                    unset($tempPrefixes[$key]);
                    $displayConditions['prefixArray'][$key]['prefixLink'] = array_values($tempPrefixes);
                    $displayConditions['prefixArray'][$key]['prefix_id'] = $prefix;
                }
            } else {
                $displayConditions['prefix_id'] = reset($prefixesArray);
            }
        }

        return $displayConditions;
    } /* END _getDisplayConditions */

    protected function _getUsersFromInput($usernames)
    {
        /* @var $userModel XenForo_Model_User */
        $userModel = $this->_getUserModel();
        $notFound = array();
        $users = $userModel->getUsersByNames($usernames, array(), $notFound);

        if ($notFound) {
            $this->responseError(
                new XenForo_Phrase('following_members_not_found_x',
                    array(
                        'members' => implode(', ', $notFound)
                    )));
        }
        return $users;
    } /* END _getUsersFromInput */

    /**
     * Returns error if filters used incorrectly
     */
    protected function _filterCheck()
    {
        $members = $this->_input->filterSingle('members', XenForo_Input::STRING);
        $searchType = $this->_input->filterSingle('search_type', XenForo_Input::STRING);
        if (empty($members) || empty($searchType)) {
            $this->responseError(new XenForo_Phrase('waindigo_thread_filters_used_incorrectly_threadfilters'));
        }
    } /* END _filterCheck */

    /**
     *
     * @return XenForo_Model_User
     */
    protected function _getUserModel()
    {
        return $this->getModelFromCache('XenForo_Model_User');
    } /* END _getUserModel */
}