<?php

/**
 *
 * @see XenForo_Model_Thread
 */
class Waindigo_ThreadFilters_Extend_XenForo_Model_Thread extends XFCP_Waindigo_ThreadFilters_Extend_XenForo_Model_Thread
{

    /**
     *
     * @see XenForo_Model_Thread::prepareThreadFetchOptions()
     */
    public function prepareThreadFetchOptions(array $fetchOptions)
    {
        $threadFetchOptions = parent::prepareThreadFetchOptions($fetchOptions);

        $joinTables = $threadFetchOptions['joinTables'];

        if (isset($fetchOptions['waindigoThreadUserId'])) {
            if (!empty($fetchOptions['waindigoThreadUserId'])) {
                $joinTables .= '
					INNER JOIN xf_thread_user_post AS waindigo_user_post_count
						ON (waindigo_user_post_count.thread_id = thread.thread_id
						AND waindigo_user_post_count.user_id IN ( ' .
                     $this->_getDb()->quote($fetchOptions['waindigoThreadUserId']) . '))';
            }
        }

        return array(
            'selectFields' => $threadFetchOptions['selectFields'],
            'joinTables' => $joinTables,
            'orderClause' => $threadFetchOptions['orderClause']
        );
    } /* END prepareThreadFetchOptions */

    /**
     *
     * @see XenForo_Model_Thread::prepareThreadConditions()
     *
     */
    public function prepareThreadConditions(array $conditions, array &$fetchOptions)
    {
        $sqlConditions = array();
        $db = $this->_getDb();
        if (!empty($conditions['specific_thread_id'])) {
            if (is_array($conditions['specific_thread_id'])) {
                $sqlConditions[] = 'thread.thread_id IN (' . $db->quote($conditions['specific_thread_id']) . ')';
            } else {
                $sqlConditions[] = 'thread.thread_id = ' . $db->quote($conditions['specific_thread_id']);
            }
        }

        return parent::prepareThreadConditions($conditions, $fetchOptions) . ' AND ' .
             $this->getConditionsForClause($sqlConditions);
        ;
    } /* END prepareThreadConditions */
}