<?php

/**
 *
 * @see Waindigo_Library_DataWriter_Article
 */
class Waindigo_Thumbnails_Extend_Waindigo_Library_DataWriter_Article extends XFCP_Waindigo_Thumbnails_Extend_Waindigo_Library_DataWriter_Article
{

    /**
     *
     * @see Waindigo_Library_DataWriter_Article::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_article']['thumbnail_url'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see Waindigo_Library_DataWriter_Article::_discussionPreSave()
     */
    protected function _discussionPreSave()
    {
        parent::_discussionPreSave();

        if (!empty($GLOBALS['Waindigo_Library_ControllerPublic_Article'])) {
            /* @var $controller Waindigo_Library_ControllerPublic_Article */
            $controller = $GLOBALS['Waindigo_Library_ControllerPublic_Article'];

            $thumbnailUrl = $controller->getInput()->filterSingle('thumbnail_url', XenForo_Input::STRING);
            $this->set('thumbnail_url', $thumbnailUrl);
        }

        if (!empty($GLOBALS['Waindigo_Library_ControllerPublic_Library'])) {
            /* @var $controller Waindigo_Library_ControllerPublic_Library */
            $controller = $GLOBALS['Waindigo_Library_ControllerPublic_Library'];

            $thumbnailUrl = $controller->getInput()->filterSingle('thumbnail_url', XenForo_Input::STRING);
            $this->set('thumbnail_url', $thumbnailUrl);
        }
    } /* END _discussionPreSave */ /* END _preSave */
}