<?php

/**
 *
 * @see XenForo_ControllerAdmin_Forum
 */
class Waindigo_Thumbnails_Extend_XenForo_ControllerAdmin_Forum extends XFCP_Waindigo_Thumbnails_Extend_XenForo_ControllerAdmin_Forum
{

    /**
     *
     * @see XenForo_ControllerAdmin_Forum::actionEdit()
     */
    public function actionEdit()
    {
        $response = parent::actionEdit();

        $forumModel = $this->_getForumModel();

        if ($nodeId = $this->_input->filterSingle('node_id', XenForo_Input::UINT)) {
            // if a node ID was specified, we should be editing, so make sure a forum exists
            $forum = $forumModel->getForumById($nodeId);
        } else {
            $forum = array(
                'thumb_source' => '',
                'thumb_width' => 0,
                'thumb_height' => 0
            );
        }

        $ThumbnailsModel = $this->_getThumbnailsModel();

        $response->params['preparedOption'] = array();
        $response->params['preparedOption']['option_value'] = $ThumbnailsModel->getOptionValue($forum);

        $response->params['preparedOption']['width'] = $forum['thumb_width'];
        $response->params['preparedOption']['height'] = $forum['thumb_height'];

        $response->params['preparedOption'] = $ThumbnailsModel->getPreparedOption($response->params['preparedOption']);

        array_unshift($response->params['preparedOption']['sources'], new XenForo_Phrase('waindigo_default_thumbnails'));

        return $response;
    } /* END actionEdit */

    /**
     *
     * @see XenForo_ControllerAdmin_Forum::actionSave()
     */
    public function actionSave()
    {
        $GLOBALS['XenForo_ControllerAdmin_Forum'] = $this;
        return parent::actionSave();
    } /* END actionSave */

    /**
     *
     * @return Waindigo_Thumbnails_Model_Thumbnails
     */
    protected function _getThumbnailsModel()
    {
        return $this->getModelFromCache('Waindigo_Thumbnails_Model_Thumbnails');
    } /* END _getThumbnailsModel */
}