<?php

/**
 *
 * @see XenForo_ControllerPublic_Category
 */
class Waindigo_Thumbnails_Extend_XenForo_ControllerPublic_Category extends XFCP_Waindigo_Thumbnails_Extend_XenForo_ControllerPublic_Category
{

    /**
     *
     * @see XenForo_ControllerPublic_Category::actionIndex()
     */
    public function actionIndex()
    {
        $responseView = parent::actionIndex();

        if ($responseView instanceof XenForo_ControllerResponse_View) {
            $thumbnailsModel = $this->_getThumbnailsModel();

            if (!empty($responseView->params['nodeList']['nodesGrouped']) &&
                 XenForo_Application::get('options')->waindigo_thumbsNodeView_thumbnails) {
                $thumbnailsModel->addThumbsToNodesGrouped($responseView->params['nodeList']['nodesGrouped']);
            }
        }

        return $responseView;
    } /* END actionIndex */

    /**
     *
     * @return Waindigo_Thumbnails_Model_Thumbnails
     */
    protected function _getThumbnailsModel()
    {
        return $this->getModelFromCache('Waindigo_Thumbnails_Model_Thumbnails');
    } /* END _getThumbnailsModel */
}