<?php

/**
 *
 * @see XenForo_DataWriter_Discussion_Thread
 */
class Waindigo_Thumbnails_Extend_XenForo_DataWriter_Discussion_Thread extends XFCP_Waindigo_Thumbnails_Extend_XenForo_DataWriter_Discussion_Thread
{

    /**
     *
     * @see XenForo_DataWriter_Discussion_Thread::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_thread']['thumbnail_url'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        $fields['xf_thread']['thumbnail_cache_waindigo'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );

        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenForo_DataWriter_Discussion_Thread::_discussionPreSave()
     */
    protected function _discussionPreSave()
    {
        parent::_discussionPreSave();

        if (!empty($GLOBALS['XenForo_ControllerPublic_Forum']) || !empty($GLOBALS['XenForo_ControllerPublic_Thread'])) {
            if (!empty($GLOBALS['XenForo_ControllerPublic_Thread'])) {
                /* @var $controller XenForo_ControllerPublic_Thread */
                $controller = $GLOBALS['XenForo_ControllerPublic_Thread'];
            } else {
                /* @var $controller XenForo_ControllerPublic_Forum */
                $controller = $GLOBALS['XenForo_ControllerPublic_Forum'];
            }
            $thumbnailUrlShown = $controller->getInput()->filterSingle('thumbnail_url_shown', XenForo_Input::UINT);
            if ($thumbnailUrlShown) {
                $thumbnailUrl = $controller->getInput()->filterSingle('thumbnail_url', XenForo_Input::STRING);
                $this->set('thumbnail_url', $thumbnailUrl);
            }
        }

        if ($this->isChanged('thumbnail_url')) {
            $this->set('thumbnail_cache_waindigo', '');
        }
    } /* END _discussionPreSave */
}