<?php

class Waindigo_Thumbnails_Install_Controller extends Waindigo_Install
{

    protected $_resourceManagerUrl = 'http://xenforo.com/community/resources/thumbnails-by-waindigo.223/';

    protected function _preInstall()
    {
        $addOn = $this->getModelFromCache('XenForo_Model_AddOn')->getAddOnById('Waindigo_ThreadThumbnails');

        if ($addOn) {
            $options = array(
                'waindigo_showInForums_threadThumbs' => 'waindigo_showInForums_thumbnails',
                'waindigo_thumbSources_threadThumbs' => 'waindigo_thumbSources_thumbnails',
                'waindigo_thumbSticky_threadThumbs' => 'waindigo_thumbSticky_thumbnails',
                'waindigo_thumbStickyArticles_threadThumbs' => 'waindigo_thumbStickyArticles_thumbnails',
                'waindigo_thumbSearch_threadThumbs' => 'waindigo_thumbSearch_thumbnails',
                'waindigo_thumbsNodeView_threadThumbs' => 'waindigo_thumbsNodeView_thumbnails',
                'waindigo_thumbWidth_threadThumbs' => 'waindigo_thumbWidth_thumbnails',
                'waindigo_thumbHeight_threadThumbs' => 'waindigo_thumbHeight_thumbnails',
                'waindigo_noThumbImage_threadThumbs' => 'waindigo_noThumbImage_thumbnails',
                'waindigo_lastPostAvatar_threadThumbs' => 'waindigo_lastPostAvatar_thumbnails'
            );

            foreach ($options as $oldOption => $newOption) {
                $this->_db->update('xf_option',
                    array(
                        'option_id' => $newOption,
                        'addon_id' => 'Waindigo_Thumbnails'
                    ), 'option_id = ' . $this->_db->quote($oldOption));
            }

            $dw = XenForo_DataWriter::create('XenForo_DataWriter_AddOn');
            $dw->setExistingData($addOn);
            $dw->set('uninstall_callback_class', '');
            $dw->set('uninstall_callback_method', '');
            $dw->delete();
        }

        if ($this->_isTableExists('xf_thumbnail_proxy_waindigo')) {
            $this->_db->delete('xf_thumbnail_proxy_waindigo', 'image_id != 0');
        }
    } /* END _preInstall */

    protected function _getTables()
    {
        return array(
            'xf_thumbnail_waindigo' => array(
                'content_id' => 'INT(11) UNSIGNED NOT NULL', /* END 'thread_id' */
                'content_type' => 'VARCHAR(25) NOT NULL COMMENT \'eg: thread\'', /* END 'content_type' */
                'thumb_url' => 'VARCHAR(255) DEFAULT \'\'', /* END 'thumbnail' */
                'thumb_width' => 'INT(11) DEFAULT 0', /* END 'thumb_width' */
                'thumb_height' => 'INT(11) DEFAULT 0', /* END 'thumb_height' */
            ), /* END 'xf_thumbnail_waindigo' */
            'xf_thumbnail_proxy_waindigo' => array(
                'thumbnail_id' => 'int(11) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY',
                'image_id' => 'int(11) unsigned NOT NULL DEFAULT 0',
                'url' => 'text NOT NULL',
                'url_hash' => 'varbinary(32) NOT NULL',
                'file_size' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'file_name' => 'varchar(250) NOT NULL DEFAULT \'\'',
                'mime_type' => 'varchar(100) NOT NULL DEFAULT \'\'',
                'fetch_date' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'first_request_date' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'last_request_date' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'views' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'pruned' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'is_processing' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'failed_date' => 'int(10) unsigned NOT NULL DEFAULT 0',
                'fail_count' => 'smallint(5) unsigned NOT NULL DEFAULT 0'
            ), /* END 'xf_thumbnail_proxy_waindigo' */
        );
    } /* END _getTables */

    protected function _getUniqueKeys()
    {
        return array(
            'xf_thumbnail_proxy_waindigo' => array(
                'url_hash' => array(
                    'url_hash'
                ), /* END 'url_hash' */
            ), /* END 'xf_thumbnail_proxy_waindigo' */
        );
    } /* END _getUniqueKeys */

    protected function _getKeys()
    {
        return array(
            'xf_thumbnail_proxy_waindigo' => array(
                'pruned_fetch_date' => array(
                    'pruned',
                    'fetch_date'
                ), /* END 'pruned_fetch_date' */
                'last_request_date' => array(
                    'last_request_date'
                ), /* END 'last_request_date' */
            ), /* END 'xf_thumbnail_proxy_waindigo' */
        );
    } /* END _getKeys */

    protected function _getTableChanges()
    {
        return array(
            'xf_thread' => array(
                'thumbnail_url' => 'VARCHAR(255) DEFAULT \'\'', /* END 'thumbnail_url' */
                'thumbnail_cache_waindigo' => 'MEDIUMBLOB NULL', /* END 'thumbnail_cache_waindigo' */
            ), /* END 'xf_thread' */
            'xf_forum' => array(
                'thumb_sources' => 'VARCHAR(255) DEFAULT \'\'', /* END 'thumb_sources' */
                'thumb_width' => 'INT(11) DEFAULT 0', /* END 'thumb_width' */
                'thumb_height' => 'INT(11) DEFAULT 0', /* END 'thumb_height' */
            ), /* END 'xf_forum' */
        );
    } /* END _getTableChanges */

    protected function _getAddOnTableChanges()
    {
        return array(
            'Waindigo_SocialGroups' => array(
                'xf_social_forum' => array(
                    'thumb_sources' => 'VARCHAR(255) DEFAULT \'\'', /* END 'thumb_sources' */
                    'thumb_width' => 'INT(11) DEFAULT 0', /* END 'thumb_width' */
                    'thumb_height' => 'INT(11) DEFAULT 0', /* END 'thumb_height' */
                ), /* END 'xf_social_forum' */
            ), /* END 'Waindigo_SocialGroups' */
        );
    } /* END _getAddOnTableChanges */
}