<?php

class Waindigo_Thumbnails_Listener_LoadClass extends Waindigo_Listener_LoadClass
{

    protected function _getExtendedClasses()
    {
        return array(
            'Waindigo_Thumbnails' => array(
                'controller' => array(
                    'Waindigo_SocialGroups_ControllerAdmin_SocialCategory',
                    'XenForo_ControllerAdmin_Forum',
                    'XenForo_ControllerPublic_Index',
                    'XenForo_ControllerPublic_Forum',
                    'XenForo_ControllerPublic_Category',
                    'Waindigo_Library_ControllerPublic_Library',
                    'XenForo_ControllerPublic_Thread',
                    'Waindigo_SocialGroups_ControllerPublic_SocialForum',
                    'XenForo_ControllerPublic_FindNew',
                    'XenForo_ControllerPublic_Watched',
                    'XenForo_ControllerAdmin_Option',
                    'XenForo_ControllerAdmin_Log'
                ), /* END 'controller' */
                'datawriter' => array(
                    'XenForo_DataWriter_Discussion_Thread',
                    'XenForo_DataWriter_Forum',
                    'XenForo_DataWriter_Option',
                    'XenForo_DataWriter_DiscussionMessage_Post'
                ), /* END 'datawriter' */
                'installer_waindigo' => array(
                    'Waindigo_SocialGroups_Install',
                    'Waindigo_SocialGroups_Install_Controller'
                ), /* END 'installer_waindigo' */
                'model' => array(
                    'XenForo_Model_Attachment',
                    'XenForo_Model_Node',
                    'Waindigo_NoForo_Model_NoForo'
                ), /* END 'model' */
                'search_data' => array(
                    'XenForo_Search_DataHandler_Thread',
                    'Waindigo_Library_Search_DataHandler_Article'
                ), /* END 'search_data' */
                'view' => array(
                    'XenForo_ViewPublic_Thread_Save_ThreadListItem'
                ), /* END 'view' */
                'proxyoutput' => array(
                    'XenForo_ProxyOutput'
                ), /* END 'proxyoutput' */
                'widget_renderer' => array(
                    'WidgetFramework_WidgetRenderer_Threads'
                ), /* END 'widget_renderer' */
            ), /* END 'Waindigo_Thumbnails' */
        );
    } /* END _getExtendedClasses */

    public static function loadClassController($class, array &$extend)
    {
        $loadClassController = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'controller');
        $extend = $loadClassController->run();
    } /* END loadClassController */

    public static function loadClassDataWriter($class, array &$extend)
    {
        $loadClassDataWriter = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'datawriter');
        $extend = $loadClassDataWriter->run();
    } /* END loadClassDataWriter */

    public static function loadClassInstallerWaindigo($class, array &$extend)
    {
        $loadClassInstallerWaindigo = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'installer_waindigo');
        $extend = $loadClassInstallerWaindigo->run();
    } /* END loadClassInstallerWaindigo */

    public static function loadClassModel($class, array &$extend)
    {
        $loadClassModel = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'model');
        $extend = $loadClassModel->run();
    } /* END loadClassModel */

    public static function loadClassSearchData($class, array &$extend)
    {
        $loadClassSearchData = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'search_data');
        $extend = $loadClassSearchData->run();
    } /* END loadClassSearchData */

    public static function loadClassView($class, array &$extend)
    {
        $loadClassView = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'view');
        $extend = $loadClassView->run();
    } /* END loadClassView */

    public static function loadClassProxyoutput($class, array &$extend)
    {
        $loadClassProxyoutput = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'proxyoutput');
        $extend = $loadClassProxyoutput->run();
    } /* END loadClassProxyoutput */

    public static function loadClassWidgetRenderer($class, array &$extend)
    {
        $loadClassWidgetRenderer = new Waindigo_Thumbnails_Listener_LoadClass($class, $extend, 'widget_renderer');
        $extend = $loadClassWidgetRenderer->run();
    } /* END loadClassWidgetRenderer */
}