<?php

class Waindigo_Thumbnails_Listener_TemplateCreate extends Waindigo_Listener_TemplateCreate
{

    protected function _getTemplates()
    {
        return array(
            'category_view',
            'forum_list',
            'forum_view',
            'search_results',
            'thread_create',
            'thread_edit',
            'waindigo_library_view_library'
        );
    } /* END _getTemplates */

    public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
    {
        $templateCreate = new Waindigo_Thumbnails_Listener_TemplateCreate($templateName, $params, $template);
        list($templateName, $params) = $templateCreate->run();
    } /* END templateCreate */

    protected function _categoryView()
    {
        $this->_preloadTemplate('waindigo_library_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_library_list_replace_thumbnails');
        $this->_preloadTemplate('waindigo_forum_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_forum_list_replace_thumbnails');
    } /* END _categoryView */

    protected function _forumList()
    {
        $this->_preloadTemplate('waindigo_library_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_library_list_replace_thumbnails');
        $this->_preloadTemplate('waindigo_forum_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_forum_list_replace_thumbnails');
    } /* END _forumList */

    protected function _forumView()
    {
        $this->_preloadTemplate('thread_list_item');
        $this->_preloadTemplate('waindigo_forum_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_thread_list_avatar_replace_thumbnails');
        $this->_preloadTemplate('waindigo_thread_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_thread_list_avatar_last_post_avatar');
    } /* END _forumView */

    protected function _waindigoLibraryViewLibrary()
    {
        $this->_preloadTemplate('waindigo_article_list_thumbnail_thumbnails');
    } /* END _waindigoLibraryViewLibrary */

    protected function _searchResults()
    {
        $this->_preloadTemplate('waindigo_article_list_thumbnail_thumbnails');
        $this->_preloadTemplate('waindigo_thread_list_thumbnail_thumbnails');
    } /* END _searchResults */

    protected function _threadCreate()
    {
        $this->_preloadTemplate('waindigo_thread_create_form_replace_thumbnails');
        $this->_preloadTemplate('waindigo_thread_create_form_thumbnails');
        $this->_preloadTemplate('waindigo_thread_create_fields_thumbnails');
    } /* END _threadCreate */

    protected function _threadEdit()
    {
        $this->_preloadTemplate('waindigo_thread_edit_url_thumbnails');
    } /* END _threadEdit */
}