<?php

class Waindigo_Thumbnails_Listener_TemplateHook extends Waindigo_Listener_TemplateHook
{

    protected function _getHooks()
    {
        return array(
            'admin_forum_edit_tabs',
            'admin_forum_edit_panes',
            'thread_list_threads',
            'thread_list_stickies',
            'waindigo_search_result_article_thumbnails',
            'waindigo_search_result_thread_thumbnails',
            'thread_create_fields_extra',
            'waindigo_thread_edit_thumbnails',
            'waindigo_thread_list_item_edit_thumbnails',
            'waindigo_article_list_item_avatar_library'
        );
    } /* END _getHooks */

    public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
        $templateHook = new Waindigo_Thumbnails_Listener_TemplateHook($hookName, $contents, $hookParams, $template);
        $contents = $templateHook->run();
    } /* END templateHook */

    protected function _adminForumEditTabs()
    {
        $this->_appendTemplate("waindigo_forum_edit_tab_thumbnails");
    } /* END _adminForumEditTabs */

    protected function _adminForumEditPanes()
    {
        $this->_appendTemplate("waindigo_forum_edit_pane_thumbnails");
    } /* END _adminForumEditPanes */

    protected function _threadListThreads()
    {
        $this->_threadListAnyThreads('threads');
    } /* END _threadListThreads */

    protected function _threadListStickies()
    {
        if (XenForo_Application::get('options')->waindigo_thumbSticky_thumbnails)
            $this->_threadListAnyThreads('stickyThreads');
    } /* END _threadListStickies */

    protected function _threadListAnyThreads($threadType)
    {
        if (XenForo_Application::$versionId > 1020000) {
            return;
        }
        $viewParams = $this->_fetchViewParams();
        $showInForums = XenForo_Application::get('options')->waindigo_showInForums_thumbnails;
        if (!isset($viewParams[$threadType]) or
             ($showInForums['_type'] == "_some" and !isset($showInForums[$viewParams['forum']['node_id']]))) {
            return;
        }
        foreach ($viewParams[$threadType] as $viewParams['thread']) {
            $viewParams['showLastPageNumbers'] = true;
            $viewParams['linkPrefix'] = true;
            if (isset($viewParams['thread']['thumbnail'])) {
                $pattern = '#(<li id="thread-' . $viewParams['thread']['thread_id'] .
                     '"[^>]*>\s*)<div class="listBlock posterAvatar">\s*<span class="avatarContainer">.*</span>\s*</div>#Us';
                $replacement = '${1}' .
                     $this->_escapeDollars($this->_render('waindigo_forum_list_thumbnail_thumbnails', $viewParams));
                $this->_patternReplace($pattern, $replacement);
            }
            if (!empty($viewParams['thread']['lastPostInfo']['thumbnail'])) {
                $pattern = '#(<li id="thread-' . $viewParams['thread']['thread_id'] .
                     '".*<dl class="lastPostInfo">)\s*<a[^>]*><img[^>]*></a>(.*</dl>.*</li>)#Us';
                $replacement = '${1}' . $this->_render('waindigo_thread_list_avatar_last_post_avatar', $viewParams) . '${2}';
                $this->_contents = preg_replace($pattern, $replacement, $this->_contents);
            }
        }
    } /* END _threadListAnyThreads */

    protected function _waindigoSearchResultArticleThumbnails()
    {
        $viewParams = $this->_fetchViewParams();
        if (isset($viewParams['article']['thumbnail'])) {
            $pattern = '#(<li id="article-' . $viewParams['article']['article_id'] .
                 '"[^>]*>\s*)<div class="listBlock posterAvatar">.*</div>#Us';
            $replacement = '${1}' .
                 $this->_escapeDollars($this->_render('waindigo_library_list_thumbnail_thumbnails', $viewParams));
            $this->_patternReplace($pattern, $replacement);
        }
    } /* END _waindigoSearchResultArticleThumbnails */

    protected function _waindigoSearchResultThreadThumbnails()
    {
        $viewParams = $this->_fetchViewParams();
        if (isset($viewParams['thread']['thumbnail'])) {
            $pattern = '#(<li id="thread-' . $viewParams['thread']['thread_id'] .
                 '"[^>]*>\s*)<div class="listBlock posterAvatar">.*</div>#Us';
            $replacement = '${1}' .
                 $this->_escapeDollars($this->_render('waindigo_forum_list_thumbnail_thumbnails', $viewParams));
            $this->_patternReplace($pattern, $replacement);
        }
    } /* END _waindigoSearchResultThreadThumbnails */

    protected function _threadCreateFieldsExtra()
    {
        $thumbnailsModel = XenForo_Model::create('Waindigo_Thumbnails_Model_Thumbnails');
        if ($thumbnailsModel->isInThumbSources(1, $this->_hookParams['forum']))
            $this->_appendTemplate('waindigo_thread_create_fields_thumbnails');
    } /* END _threadCreateFieldsExtra */

    protected function _waindigoArticleListItemAvatarLibrary()
    {
        $viewParams = $this->_fetchViewParams();
        if (isset($viewParams['article']['thumbnail']) &&
             (!isset($viewParams['sticky']) ||
             XenForo_Application::get('options')->waindigo_thumbStickyArticles_thumbnails)) {
            $this->_replaceWithTemplate('waindigo_library_list_thumbnail_thumbnails');
        }
    } /* END _waindigoArticleListItemAvatarLibrary */
}