<?php

class Waindigo_Thumbnails_Listener_TemplatePostRender extends Waindigo_Listener_TemplatePostRender
{

    protected function _getTemplates()
    {
        return array(
            'PAGE_CONTAINER',
            'thread_view',
            'thread_create',
            'thread_edit',
            'thread_list_item_edit',
            'node_forum_level_1',
            'node_forum_level_2',
            'waindigo_node_level_1_social_groups',
            'waindigo_node_level_2_social_groups',
            'waindigo_library_level_1_library',
            'waindigo_library_level_2_library'
        );
    } /* END _getTemplates */

    public static function templatePostRender($templateName, &$content, array &$containerData,
        XenForo_Template_Abstract $template)
    {
        $templatePostRender = new Waindigo_Thumbnails_Listener_TemplatePostRender($templateName, $content,
            $containerData, $template);
        list($content, $containerData) = $templatePostRender->run();
    } /* END templatePostRender */

    protected function _pageContainer()
    {
        if (isset($GLOBALS['waindigo_thread_open_graph'])) {
            $this->_contents = preg_replace('/(<meta property="og:site_name" content="(.*?)" \/>)/',
                '$1<meta property="og:image" content="' . $GLOBALS['waindigo_thread_open_graph'] . '" \/>',
                $this->_contents);
        }
    } /* END _pageContainer */

    protected function _threadView()
    {
        $viewParams = $this->_fetchViewParams();
        if (isset($viewParams['thread']['open_graph'])) {
            $GLOBALS['waindigo_thread_open_graph'] = $viewParams['thread']['open_graph'];
        }
    } /* END _threadView */

    protected function _threadCreate()
    {
        $this->_template->addRequiredExternal('js', 'js/waindigo/thumbnails/thumbnails.js');
        $viewParams = $this->_fetchViewParams();
        $forum = $viewParams['forum'];
        $pattern = '#(<form\s*action="[^"]*\s*[^>]*class="[^"]*)("[^>]*)(>)#Us';
        $replacement = '${1} Thumbnails${2} data-thumbnailsurl="' .
             XenForo_Link::buildPublicLink('forums/create-thread/thumbnails', $forum) . '"${3}';
        $this->_patternReplace($pattern, $replacement);
    } /* END _threadCreate */

    protected function _threadEdit()
    {
        $viewParams = $this->_fetchViewParams();
        $thumbnailsModel = XenForo_Model::create('Waindigo_Thumbnails_Model_Thumbnails');
        if ($thumbnailsModel->isInThumbSources(1, $viewParams['forum'])) {
            $codeSnippet = '<dl class="ctrlUnit submitUnit">';
            $this->_appendTemplateBeforeCodeSnippet($codeSnippet, 'waindigo_thread_edit_url_thumbnails');
        }
    } /* END _threadEdit */ /* END _waindigoThreadEditThumbnails */

    protected function _threadListItemEdit()
    {
        $viewParams = $this->_fetchViewParams();
        $thumbnailsModel = XenForo_Model::create('Waindigo_Thumbnails_Model_Thumbnails');
        if ($thumbnailsModel->isInThumbSources(1, $viewParams['forum'])) {
            $codeSnippet = '<div class="buttons editBlock">';
            $this->_appendTemplateBeforeCodeSnippet($codeSnippet, 'waindigo_thread_list_item_edit_url_thumbnails');
        }
    } /* END _threadListItemEdit */ /* END _waindigoThreadListItemEditThumbnails */

    protected function _nodeForumLevel1()
    {
        $this->_nodeForumLevel2();
    }

    protected function _nodeForumLevel2()
    {
        $viewParams = $this->_fetchViewParams();
        $thumbnailsModel = $this->_getThumbnailsModel();
        if (isset($viewParams['forum'])) {
            $node = $viewParams['forum'];
            $showInForums = XenForo_Application::get('options')->waindigo_showInForums_thumbnails;
            if ($showInForums['_type'] == "_some" && !isset($showInForums[$node['node_id']])) {
                return;
            }
        } else
            if (isset($viewParams['library'])) {
                $node = $viewParams['library'];
                $showInLibraries = XenForo_Application::get('options')->waindigo_showInLibraries_thumbnails;
                if ($showInLibraries['_type'] == "_some" && !isset($showInLibraries[$node['node_id']])) {
                    return;
                }
            }

        if (!$node['privateInfo']) {
            if (isset($node['article']) && isset($node['article']['thumbnail'])) {
                $viewParams['article'] = $node['article'];
                $codeSnippet = $this->_render('waindigo_library_list_replace_thumbnails');
                $this->_replaceWithTemplateAtCodeSnippet($codeSnippet, 'waindigo_library_list_thumbnail_thumbnails',
                    $viewParams);
            } elseif (isset($node['thread']) && isset($node['thread']['thumbnail'])) {
                $viewParams['thread'] = $node['thread'];
                $codeSnippet = $this->_render('waindigo_forum_list_replace_thumbnails');
                $this->_replaceWithTemplateAtCodeSnippet($codeSnippet, 'waindigo_forum_list_thumbnail_thumbnails',
                    $viewParams);
            }
        }
    }

    protected function _waindigoNodeLevel1SocialGroups()
    {
        $this->_nodeForumLevel1();
    }

    protected function _waindigoNodeLevel2SocialGroups()
    {
        $this->_nodeForumLevel2();
    }

    protected function _waindigoLibraryLevel1Library()
    {
        $this->_nodeForumLevel1();
    }

    protected function _waindigoLibraryLevel2Library()
    {
        $this->_nodeForumLevel2();
    }

    /**
     *
     * @return Waindigo_Thumbnails_Model_Thumbnails
     */
    protected function _getThumbnailsModel()
    {
        $this->getModelFromCache('Waindigo_Thumbnails_Model_Thumbnails');
    } /* END _getThumbnailsModel */
}