<?php

/**
 *
 * @see XenForo_ControllerPublic_Account
 */
class Waindigo_TrophyProgress_Extend_XenForo_ControllerPublic_Account extends XFCP_Waindigo_TrophyProgress_Extend_XenForo_ControllerPublic_Account
{

    /**
     *
     * @see XenForo_ControllerPublic_Account::actionPreferences()
     */
    public function actionPreferences()
    {
        $response = parent::actionPreferences();
        
        $visitor = XenForo_Visitor::getInstance()->toArray();
        $trophyPoints = $visitor['trophy_points'];
        if (XenForo_Application::$versionId > 1040000) {
            $trophyPoints = $this->_getUserTitlePoints($visitor, $trophyPoints);
                $trophyTitles = array_reverse(XenForo_Application::get('userTitleLadder'), true);
        } else {
            $trophyTitles = array_reverse(XenForo_Application::get('trophyUserTitles'), true);
        }
        
        $userTrophyTitles = array();
        $level = 1;
        foreach ($trophyTitles as $points => $title) {
            if ($points < $trophyPoints) {
                $userTrophyTitles[$level] = array(
                    'level' => $level,
                    'title' => $title
                );
            }
            $level++;
        }
        $response->subView->params['trophyTitles'] = $userTrophyTitles;
        
        return $response;
    } /* END actionPreferences */

    /**
     *
     * @see XenForo_ControllerPublic_Account::actionPreferencesSave()
     */
    public function actionPreferencesSave()
    {
        $GLOBALS['XenForo_ControllerPublic_Account'] = $this;
        
        return parent::actionPreferencesSave();
    } /* END actionPreferencesSave */
    
    protected function _getUserTitlePoints(array $visitor, $trophyPoints)
    {
        $userTitleType = XenForo_Application::get('options')->userTitleLadderField;
        if ($userTitleType != 'trophy_points') {
            return XenForo_Visitor::getInstance()->toArray()[$userTitleType];
        } else {
            return $trophyPoints;
        }
    } /* END _getUserTitlePoints */
}