<?php

/**
 *
 * @see XenForo_DataWriter_User
 */
class Waindigo_TrophyProgress_Extend_XenForo_DataWriter_User extends XFCP_Waindigo_TrophyProgress_Extend_XenForo_DataWriter_User
{
    
    /**
     *
     * @see XenForo_DataWriter_User::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_user']['trophy_title_waindigo'] = array(
            'type' => self::TYPE_STRING,
            'default' => ''
        );
        return $fields;
    } /* END _getFields */
    
    /**
     *
     * @see XenForo_DataWriter_User::_preSave()
     */
    protected function _preSave()
    {
        if (isset($GLOBALS['XenForo_ControllerPublic_Account'])) {
            /* @var $input XenForo_ControllerPublic_Account */
            $input = $GLOBALS['XenForo_ControllerPublic_Account'];
    
            $trophyTitle = $input->getInput()->filterSingle('trophy_title_waindigo', XenForo_Input::STRING);
            if (!$trophyTitle) {
                $this->set('trophy_title_waindigo', null);
            } else {
                $this->set('trophy_title_waindigo', $trophyTitle);
            }
        }
    
        parent::_preSave();
    } /* END _preSave */
}