<?php

class Waindigo_TrophyProgress_Listener_FrontControllerPreView extends Waindigo_Listener_FrontControllerPreView
{

    public function run()
    {
        $visitor = XenForo_Visitor::getInstance()->toArray();
        
        if ($this->_viewRenderer instanceof XenForo_ViewRenderer_HtmlPublic &&
             $this->_controllerResponse instanceof XenForo_ControllerResponse_View && XenForo_Visitor::getUserId()) {
            $trophyPoints = $visitor['trophy_points'];
            if (XenForo_Application::$versionId > 1040000) {
                $trophyPoints = $this->_getUserTitlePoints($visitor, $trophyPoints);
                $trophyTitles = array_reverse(XenForo_Application::get('userTitleLadder'), true);
            } else {
                $trophyTitles = array_reverse(XenForo_Application::get('trophyUserTitles'), true);
            }
            
            $currentLevel = $currentTrophyTitle = $currentTrophyPoints = $nextTrophyTitle = $nextTrophyPoints = 0;
            foreach ($trophyTitles as $points => $title) {
                $nextTrophyTitle = $title;
                $nextTrophyPoints = $points;
                if ($trophyPoints < $points) {
                    break;
                }
                $currentLevel++;
                $currentTrophyTitle = $title;
                $currentTrophyPoints = $points;
            }
            
            $userTrophyTitles = $this->getUserTitles($trophyTitles);
            
            $totalPointsForNextLevel = $nextTrophyPoints - $currentTrophyPoints;
            $nextLevelProgress = $trophyPoints - $currentTrophyPoints;
            if ($totalPointsForNextLevel == 0) {
                $levelProgress = 100;
            } else {
                $levelProgress = round(($nextLevelProgress / $totalPointsForNextLevel) * 100);
            }
            if ($visitor['trophy_title_waindigo'] == $currentLevel) {
                $levelsMatch = true;
            } else {
                $levelsMatch = false;
            }
            $this->_containerParams['levelsMatch'] = $levelsMatch;
            $this->_containerParams['currentLevel'] = $currentLevel;
            $this->_containerParams['userTrophyTitles'] = $userTrophyTitles;
            $this->_containerParams['currentTrophyTitle'] = $currentTrophyTitle;
            $this->_containerParams['nextTrophyTitle'] = $nextTrophyTitle;
            $this->_containerParams['levelProgress'] = $levelProgress;
            $this->_containerParams['nextLevelProgress'] = $nextLevelProgress;
            $this->_containerParams['totalPointsForNextLevel'] = $totalPointsForNextLevel;
        }
        
        return parent::run();
    } /* END run */

    public static function frontControllerPreView(XenForo_FrontController $fc, 
        XenForo_ControllerResponse_Abstract &$controllerResponse, XenForo_ViewRenderer_Abstract &$viewRenderer, 
        array &$containerParams)
    {
        $frontControllerPreView = new Waindigo_TrophyProgress_Listener_FrontControllerPreView($fc, $controllerResponse, 
            $viewRenderer, $containerParams);
        list ($controllerResponse, $viewRenderer, $containerParams) = $frontControllerPreView->run();
    } /* END frontControllerPreView */

    public static function getUserTitles(array $trophyTitles = array())
    {
        if (empty($trophyTitles)) {
            if (XenForo_Application::$versionId > 1040000) {
                $trophyTitles = array_reverse(XenForo_Application::get('userTitleLadder'), true);
            } else {
                $trophyTitles = array_reverse(XenForo_Application::get('trophyUserTitles'), true);
            }
        }
        $userTrophyTitles = array();
        $level = 1;
        foreach ($trophyTitles as $points => $title) {
            $userTrophyTitles[$level] = $title;
            $level++;
        }
        return $userTrophyTitles;
    } /* END getUserTitles */
    
    protected function _getUserTitlePoints(array $visitor, $trophyPoints)
    {
        $userTitleType = XenForo_Application::get('options')->userTitleLadderField;
        if ($userTitleType != 'trophy_points') {
            return XenForo_Visitor::getInstance()->toArray()[$userTitleType];
        } else {
            return $trophyPoints;
        }
    } /* END _getUserTitlePoints */
}