<?php

/**
 * Helper methods for the core template functions/tags.
 *
 * @package Waindigo_TrophyProgress
 *
 */
class Waindigo_TrophyProgress_Template_Callback
{

    public static function getUserTitle($content, $params)
    {
        if (!empty($params['user'])) {
            $user = $params['user'];
            $userTitle = XenForo_Template_Helper_Core::helperUserTitle($user, 1, 1);
            if (XenForo_Application::get('options')->waindigo_trophyProgress_showChosenTrophyTitle) {
                $userTrophyTitles = Waindigo_TrophyProgress_Listener_FrontControllerPreView::getUserTitles();
                if ($userTrophyTitles[$user['trophy_title_waindigo']] == $userTitle) {
                    return $userTitle;
                } elseif (in_array($userTitle, $userTrophyTitles)) {
                        return '<span class="currentTrophyTitle">' . array_search($userTitle, $userTrophyTitles) . '. ' . $userTitle . '</span></br><span class="chosenTrophyTitle">' . $userTrophyTitles[$user['trophy_title_waindigo']] . '</span>';
                } else {
                    return $userTitle . '</br>' . $userTrophyTitles[$user['trophy_title_waindigo']]; 
                }
            } else {
                return $userTitle;
            }
        }
    } /* END getUserTitle */
}