<?php

/**
 * Data writer for upgrade coupons.
 */
class Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons extends XenForo_DataWriter
{

    /**
     * Gets the fields that are defined for the table.
     * See parent for explanation.
     *
     * @return array
     */
    protected function _getFields()
    {
        return array(
            'xf_upgrade_coupon_waindigo' => array(
                'coupon_id' => array(
                    'type' => self::TYPE_UINT,
                    'autoIncrement' => true
                ), /* END 'coupon_id' */
                'is_active' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'default' => 1
                ), /* END 'is_active' */
                'single_use' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'default' => 0
                ), /* END 'single_use' */
                'title' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true
                ), /* END 'title' */
                'amount' => array(
                    'type' => self::TYPE_FLOAT,
                    'default' => '0.00'
                ), /* END 'amount' */
                'coupon_type' => array(
                    'type' => self::TYPE_STRING,
                    'allowedValues' => array(
                        'flat_rate',
                        'percentage'
                    ),
                    'default' => 'coupon_type'
                ), /* END 'coupon_type' */
                'coupon_key' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true
                ), /* END 'coupon_key' */
                'upgrade_ids' => array(
                    'type' => self::TYPE_UNKNOWN,
                    'default' => '',
                    'verification' => array(
                        '$this',
                        '_verifyUpgradeIds'
                    )
                ), /* END 'upgrade_ids' */
                'user_ids' => array(
                    'type' => self::TYPE_STRING,
                    'default' => ''
                ), /* END 'user_ids' */
                'multiple_use' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'default' => 0
                ), /* END 'multiple_use' */
                'initial_payment_only' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'default' => 0
                ), /* END 'initial_payment_only' */                
                're_entry_required' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'default' => 1
                ), /* END 're_entry_required' */
                'is_gift' => array(
                    'type' => self::TYPE_BOOLEAN,
                    'default' => 0
                ), /* END 'is_gift' */
                'gift_status' => array(
                    'type' => self::TYPE_STRING,
                    'default' => ''
                ), /* END 'user_ids' */
                'extra_data' => array(
                    'type' => self::TYPE_UNKNOWN,
                    'verification' => array(
                        '$this',
                        '_verifyExtraData'
                    )
                ), /* END 'extra_data' */
            )
        );
    } /* END _getFields */

    /**
     * Gets the actual existing data out of data that was passed in.
     * See parent for explanation.
     *
     * @param mixed
     *
     * @return array false
     */
    protected function _getExistingData($data)
    {
        if (!$couponId = $this->_getExistingPrimaryKey($data)) {
            return false;
        }

        return array(
            'xf_upgrade_coupon_waindigo' => $this->_getCouponModel()->getCouponById($couponId)
        );
    } /* END _getExistingData */

    /**
     * Gets SQL condition to update the existing record.
     *
     * @return string
     */
    protected function _getUpdateCondition($tableName)
    {
        return 'coupon_id = ' . $this->_db->quote($this->getExisting('coupon_id'));
    } /* END _getUpdateCondition */

    /**
     * Post-delete handling.
     */
    protected function _postDelete()
    {
        $this->_db->update('xf_user_profile', array(
            'coupon_id' => 0
        ), 'coupon_id = ' . $this->_db->quote($this->get('coupon_id')));
    } /* END _postDelete */

    /**
     * Verifies list of upgrade IDs.
     *
     * @param string|array $upgradeIds
     *
     * @return boolean
     */
    protected function _verifyUpgradeIds(&$upgradeIds)
    {
        if (!is_array($upgradeIds)) {
            $upgradeIds = preg_split('#,\s*#', $upgradeIds);
        }

        $upgradeIds = array_map('intval', $upgradeIds);
        $upgradeIds = array_unique($upgradeIds);
        sort($upgradeIds, SORT_NUMERIC);
        $upgradeIds = implode(',', $upgradeIds);

        return true;
    } /* END _verifyUpgradeIds */

    /**
     * Verification method for extra data
     *
     * @param string $extraData
     */
    protected function _verifyExtraData(&$extraData)
    {
        if ($extraData === null) {
            $extraData = '';
            return true;
        }

        return XenForo_DataWriter_Helper_Denormalization::verifySerialized($extraData, $this, 'extra_data');
    } /* END _verifyExtraData */

    /**
     *
     * @return Waindigo_Coupons_Model_Coupon
     */
    protected function _getCouponModel()
    {
        return XenForo_Model::create('Waindigo_UpgradeCoupons_Model_UpgradeCoupons');
    } /* END _getCouponModel */
}