<?php

/**
 *
 * @see XenForo_ControllerAdmin_UserUpgrade
 */
class Waindigo_UpgradeCoupons_Extend_XenForo_ControllerAdmin_UserUpgrade extends XFCP_Waindigo_UpgradeCoupons_Extend_XenForo_ControllerAdmin_UserUpgrade
{

    /**
     *
     * @see XenForo_ControllerAdmin_UserUpgrade::_getUpgradeAddEditResponse()
     */
    protected function _getUpgradeAddEditResponse(array $upgrade)
    {
        $upgrade = array_merge(
            array(
                'allow_coupons' => 1,
                'gift_coupon_id' => '',
                'allow_gift_purchase' => 0,
            ), $upgrade);
        
        $response = parent::_getUpgradeAddEditResponse($upgrade);
        
        $response->params['couponOptions'] = $this->getModelFromCache('Waindigo_UpgradeCoupons_Model_UpgradeCoupons')->getCouponOptions(
            $upgrade['gift_coupon_id']);
        
        return $response;
    } /* END _getUpgradeAddEditResponse */

    /**
     *
     * @see XenForo_ControllerAdmin_UserUpgrade::actionSave()
     */
    public function actionSave()
    {
        $GLOBALS['XenForo_ControllerAdmin_UserUpgrade'] = $this;
        
        return parent::actionSave();
    } /* END actionSave */
}