<?php

/**
 *
 * @see XenForo_ControllerPublic_Account
 */
class Waindigo_UpgradeCoupons_Extend_XenForo_ControllerPublic_Account extends XFCP_Waindigo_UpgradeCoupons_Extend_XenForo_ControllerPublic_Account
{

    /**
     * Applies a upgrade coupon to a users account.
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionCoupon()
    {
        $this->_assertPostOnly();
        
        if ($this->_input->filterSingle('delete', XenForo_Input::STRING)) {
            return $this->responseReroute('Waindigo_UpgradeCoupons_ControllerPublic_Account', 'deleteConfirm');
        }
        
        $couponInput = $this->_input->filterSingle('coupon_key', XenForo_Input::STRING);
        if (empty($couponInput)) {
            return $this->responseError(new XenForo_Phrase('waindigo_invalid_coupon_upgradecoupons'));
        }
        /* @var $couponModel Waindigo_UpgradeCoupons_Model_UpgradeCoupons */
        $couponModel = $this->_getCouponModel();
        $coupon = $couponModel->getCouponFromInput($couponInput);
        if (empty($coupon)) {
            return $this->responseError(new XenForo_Phrase('waindigo_invalid_coupon_upgradecoupons'));
        }
        $visitor = XenForo_Visitor::getInstance()->toArray();
        if (!$couponModel->checkCouponWithUser($coupon, $visitor['user_id'])) {
            return $this->responseError(new XenForo_Phrase('waindigo_user_cannot_use_coupon_upgradecoupons'));
        }
        $couponModel->updateUsersCouponRecord($visitor, $coupon);
        return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS, 
            XenForo_Link::buildPublicLink('account/upgrades'));
    } /* END actionCoupon */

    /**
     *
     * @see XenForo_ControllerPublic_Account::actionUpgrades()
     */
    public function actionUpgrades()
    {
        $response = parent::actionUpgrades();
        if ($response instanceof XenForo_ControllerResponse_View ||
             $response instanceof XenForo_ControllerResponse_Message) {
            if (XenForo_Visitor::getUserId()) {
                $response->subView->params['showCouponForm'] = 1;
            }
            $coupon = $this->_getCouponModel()->getCouponById(XenForo_Visitor::getInstance()->coupon_id);
            if (!empty($coupon)) {
                if ($coupon['coupon_type'] == 'flat_rate') {
                    $coupon['amount'] = number_format($coupon['amount'], 2);
                }
                $response->subView->params['coupon'] = $coupon;
            }
            /* @var $upgradeModel XenForo_Model_UserUpgrade */
            $upgradeModel = $this->_getUpgradeModel();
            $upgrades = $upgradeModel->getUserUpgradesForPurchaseList();
            if (!empty($upgrades['freeUpgrades'])) {
                $response->subView->params['freeUpgrades'] = $upgrades['freeUpgrades'];
            }
            if (!empty($upgrades['giftUpgrades'])) {
                $giftUpgrades = $upgrades['giftUpgrades'];
                $giftUpgrades[0] = array(
                    'user_upgrade_id' => 0,
                    'title' => ''
                );
                sort($giftUpgrades);
                $response->subView->params['giftUpgrades'] = $giftUpgrades;
            }
        }
        if ($response instanceof XenForo_ControllerResponse_Message && !$upgrades['available'] && !$upgrades['purchased']) {
            if (!$upgrades['freeUpgrades']) {
                return $response;
            }
            $viewParams = array(
                'payPalUrl' => 'https://www.paypal.com/cgi-bin/webscr',
                'showCouponForm' => 1,
                'freeUpgrades' => $upgrades['freeUpgrades'],
                'coupon' => $coupon
            );
            
            return $this->_getWrapper('account', 'upgrades', 
                $this->responseView('XenForo_ViewPublic_Account_Upgrades', 'account_upgrades', $viewParams));
        }
        
        return $response;
    } /* END actionUpgrades */

    /**
     * Interim confirm screen for purchasing upgrades, 
     * allows for TOS features in UserUpgrades by Waindigo
     *
     * @see XenForo_ControllerPublic_Account::actionPurchaseConfirm()
     *
     * @return $this->responseView()
     */
    public function actionFreeConfirm()
    {
        $visitor = XenForo_Visitor::getInstance();
    
        if (!$upgradeId = $this->_input->filterSingle('user_upgrade_id', XenForo_Input::INT)) {
            throw new XenForo_Exception(new XenForo_Phrase('requested_user_upgrade_not_found'), true);
        }
        
        /* @var $upgradeModel XenForo_Model_UserUpgrade */
        $upgradeModel = $this->_getUpgradeModel();
        $upgrade = $upgradeModel->getUserUpgradeById($upgradeId);
        
        $viewParams = array(
            'upgrade' => $upgrade,
            'waindigoUserUpgradesActive' => $upgradeModel->userUpgradesCheck(),
        );
    
        return $this->_getWrapper('account', 'upgrades',
            $this->responseView('Waindigo_UpgradeCoupons_ViewPublic_FreeConfirm',
                'waindigo_free_upgrades_confirm_upgradecoupons', $viewParams));
    } /* END actionFreeConfirm */
    
    /**
     * Upgrades a user for free if the user upgrade and upgrade coupon allow.
     */
    public function actionFree()
    {
        $userUpgradeId = $this->_input->filterSingle('user_upgrade_id', XenForo_Input::UINT);
        $userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
        
        /* @var $couponModel Waindigo_UpgradeCoupons_Model_UpgradeCoupons */
        $couponModel = $this->_getCouponModel();
        $coupon = $this->_getCouponModel()->getCouponFromUserId($userId);
        if (empty($coupon)) {
            return $this->responseError(new XenForo_Phrase('waindigo_invalid_coupon_upgradecoupons'));
        }
        
        /* @var $upgradeModel XenForo_Model_UserUpgrade */
        $upgradeModel = $this->_getUpgradeModel();
        $upgrade = $this->_getUpgradeModel()->getUserUpgradeById($userUpgradeId);
        if ($couponModel->checkCouponWithUpgrade($coupon, $upgrade)) {
            $upgrade = $couponModel->applyCouponToUpgrade($upgrade, $coupon);
            if ($upgrade['cost_amount'] <= 0) {
                Waindigo_UpgradeCoupons_Extend_XenForo_Model_UserUpgrade::$couponId = $coupon['coupon_id'];
                if ($this->_input->filterSingle('type', XenForo_Input::STRING) == 'gift') {
                    $upgradeModel->giftUpgrade($userId, $upgrade);
                } else {                
                    $upgradeModel->upgradeUser($userId, $upgrade);
                }
                $viewParams = array();
                return $this->_getWrapper('account', 'upgrades', 
                    $this->responseView('XenForo_ViewPublic_Account_UpgradePurchase', 'account_upgrade_purchase', 
                        $viewParams));
            }
        }
        return $this->responseError(new XenForo_Phrase('waindigo_invalid_coupon_upgradecoupons'));
    } /* END actionFree */

    /**
     * Allows a user to purchase a user upgrade coupon for someone.
     */
    public function actionGift()
    {
        $userUpgradeId = $this->_input->filterSingle('gift_upgrade_id', XenForo_Input::UINT);
        
        if (empty($userUpgradeId)) {
            return $this->responseError(new XenForo_Phrase('requested_user_upgrade_not_found'));
        }
        
        $visitor = XenForo_Visitor::getInstance()->toArray();
        
        $upgradeModel = $this->_getUpgradeModel();
        $upgrade = $upgradeModel->getUserUpgradeById($userUpgradeId);
        $upgrade = $upgradeModel->prepareUserUpgrade($upgrade);
        
        if (!empty($upgrade)) {
            /* @var $couponModel Waindigo_UpgradeCoupons_Model_UpgradeCoupons */
            $couponModel = $this->_getCouponModel();
            $couponModel->createGiftCoupon($upgrade);
            $upgradeModel->updateUpgradeForGift($upgrade, $visitor['user_id'], 'addUser');
        }
        if ($visitor['coupon_id']) {
            $coupon = $couponModel->getCouponById($visitor['coupon_id']);
            if (!empty($coupon) && !empty($upgrade)) {
                if ($couponModel->checkCouponWithUpgrade($coupon, $upgrade, $visitor['user_id'])) {
                    $upgrade = $couponModel->applyCouponToUpgrade($upgrade, $coupon);
                }
            }
        }
        
        $viewParams = array(
            'upgrade' => $upgrade,
            'payPalUrl' => 'https://www.paypal.com/cgi-bin/websrc',
            'waindigoUserUpgradesActive' => false
        );
        
        if ($upgradeModel->userUpgradesCheck()) {
            $viewParams['waindigoUserUpgradesActive'] = true;
            if ($upgrade['hidden'] && XenForo_Application::get('options')->waindigo_upgradeCoupons_overrideHiddenWhenGift) {
                $upgradeKey = md5(XenForo_Application::getSimpleCacheData(Waindigo_UserUpgrades_Extend_XenForo_ControllerPublic_Account::WAINDIGO_USERUPGRADES_HIDDENKEY) . $upgrade['user_upgrade_id']);
                $viewParams['key'] = $upgradeKey;
            }
        }
        
        return $this->_getWrapper('account', 'gift-confirm', 
            $this->responseView('XenForo_ViewPublic_Account_UpgradePurchase', 
                'waindigo_account_upgrades_gift_upgradecoupons', $viewParams));
    } /* END actionGift */

    /**
     * Purchase an upgrade
     *
     * @see XenForo_ControllerPublic_Account::actionPurchaseConfirm()
     *
     * @return $this->responseView()
     */
    public function actionGiftConfirm()
    {
        if ($this->_userUpgradesCheck()) {
            $upgrade = $this->getRequestedUpgrade();
        }
        
        $viewParams = array(
            'upgrade' => $upgrade,
            'payPalUrl' => 'https://www.paypal.com/cgi-bin/websrc'
        );
        
        if ($upgrade['hidden']) {
            $upgradeKey = md5(
                XenForo_Application::getSimpleCacheData(Waindigo_UserUpgrades_Extend_XenForo_ControllerPublic_Account::WAINDIGO_USERUPGRADES_HIDDENKEY) . $upgrade['user_upgrade_id']);
            $viewParams['key'] = $upgradeKey;
        }

        return $this->_getWrapper('account', 'upgrades', 
            $this->responseView('Waindigo_UserUpgrades_ViewPublic_PurchaseConfirm', 
                'waindigo_account_upgrades_confirm_userupgrades', $viewParams));
    } /* END actionGiftConfirm */

    /**
     * Delete confirmation and action
     *
     * @return XenForo_ControllerResponse_Abstract
     */
    public function actionDelete()
    {
        $couponId = $this->_input->filterSingle('coupon_id', XenForo_Input::UINT);
        $coupon = $this->_getCouponModel()->getCouponById($couponId);
        
        if ($this->isConfirmedPost()) {
            return $this->_deleteData('Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons', 'coupon_id', 
                XenForo_Link::buildLink('account/upgrades'));
        } else {
            
            $dw = XenForo_DataWriter::create('Waindigo_UpgradeCoupons_DataWriter_UpgradeCoupons', 
                XenForo_DataWriter::ERROR_EXCEPTION);
            $dw->setExistingData($coupon, true);
            $dw->preDelete();
            
            $viewParams = array(
                'coupon' => $coupon
            );
            return $this->responseView('XenForo_ViewAdmin_UpgradeCoupons_Delete',
                'waindigo_coupon_delete_upgradecoupons', $viewParams);
        }
    } /* END actionDelete */

    /**
     *
     * @return Waindigo_UpgradeCoupons_Model_UpgradeCoupons
     */
    protected function _getCouponModel()
    {
        return $this->getModelFromCache('Waindigo_UpgradeCoupons_Model_UpgradeCoupons');
    } /* END _getCouponModel */

    /**
     *
     * @return XenForo_Model_UserUpgrade
     */
    protected function _getUpgradeModel()
    {
        return $this->getModelFromCache('XenForo_Model_UserUpgrade');
    } /* END _getUpgradeModel */
}