<?php

/**
 *
 * @see XenForo_DataWriter_UserUpgrade
 */
class Waindigo_UpgradeCoupons_Extend_XenForo_DataWriter_UserUpgrade extends XFCP_Waindigo_UpgradeCoupons_Extend_XenForo_DataWriter_UserUpgrade
{
    /**
     * @see XenForo_DataWriter_UserUpgrade::_getFields()
     */
    protected function _getFields()
    {
        $fields = parent::_getFields();
        $fields['xf_user_upgrade']['allow_coupons'] = array(
            'type' => self::TYPE_BOOLEAN,
            'default' => 1
        );
        $fields['xf_user_upgrade']['allow_gift_purchase'] = array(
            'type' => self::TYPE_BOOLEAN,
            'default' => 0
        );
        $fields['xf_user_upgrade']['gift_coupon_id'] = array(
            'type' => self::TYPE_UINT,
            'default' => 0,
        );
        $fields['xf_user_upgrade']['gift_purchase_user_ids'] = array(
            'type' => self::TYPE_UNKNOWN,
            'default' => '',
        );
        return $fields;
    } /* END _getFields */

    /**
     *
     * @see XenForo_DataWriter_UserUpgrade::_preSave()
     */
    protected function _preSave()
    {
        if (isset($GLOBALS['XenForo_ControllerAdmin_UserUpgrade'])) {
            $input = $GLOBALS['XenForo_ControllerAdmin_UserUpgrade'];
            $this->set('allow_coupons', $input->getInput()->filterSingle('allow_coupons', XenForo_Input::BOOLEAN));
            $this->set('allow_gift_purchase', $input->getInput()->filterSingle('allow_gift_purchase', XenForo_Input::BOOLEAN));
            $this->set('gift_coupon_id', $input->getInput()->filterSingle('gift_coupon_id', XenForo_Input::UINT));
        }
        parent::_preSave();
    } /* END _preSave */
}